//   File : controller.h
//   Creation date : Thu Apr 30 2002 17:13:12 GMT by Juanjo lvarez
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Juanjo lvarez (juanjux@yahoo.es)
//   Copyright (C) 2002 Szymon Stefanek (kvirc@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

#ifndef SPASTE_CONTROLLER_H
#define SPASTE_CONTROLLER_H

#include "kvi_window.h"
#include "kvi_string.h"

#include <tqobject.h>
#include <tqstringlist.h>
#include <tqfile.h>

class SPasteController : public TQObject
{
    Q_OBJECT
  TQ_OBJECT
public:
    SPasteController(KviWindow * w,int id);
    ~SPasteController();

    //bool pasteFileInit(KviStr * fileName);
    bool pasteFileInit(TQString &fileName);
    bool pasteClipboardInit(void);
    int getId(void){return m_pId;};
    KviWindow * window(void){return m_pWindow;};
    //void stop(void);
protected slots:
    void pasteFile(void);
    void pasteClipboard(void);

private:
    TQStringList *m_pClipBuff;
    TQFile   *m_pFile;
    int m_pId;
    KviWindow *m_pWindow;
    TQTimer *m_pTimer;
    TQStringList::Iterator m_clipBuffIterator;
};

#endif //SPASTE_CONTROLLER_H
    
