#ifndef _WIZARD_H_
#define _WIZARD_H_
//
//   File : wizard.h
//   Creation date : Fri Jun 26 2002 21:21:21 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

#include "kvi_string.h"

#include <kvi_tal_wizard.h>

class KviPixmap;
class KviPixmapSelector;
class KviTalVBoxLayout; 
class KviTalHBoxLayout; 
class TQGridLayout; 
class TQCheckBox;
class TQLabel;
class TQLineEdit;
class TQWidget;
class KviRegisteredUserDataBase;

class KviRegistrationWizard : public KviTalWizard
{ 
    Q_OBJECT
  TQ_OBJECT
public:
    KviRegistrationWizard(const char * startMask,KviRegisteredUserDataBase * db = 0,TQWidget * par = 0,bool bModal = false);
    ~KviRegistrationWizard();

	KviRegisteredUserDataBase * m_pDb;

	KviStr m_szStartMask;

	bool m_bModal;

    TQWidget* m_pPage1;
    TQLabel* m_pLabel1;
    TQLineEdit* m_pEditRealName;
    TQWidget* m_pPage2;
    TQLabel* m_pLabel2;
    TQLineEdit* m_pNicknameEdit1;
    TQLineEdit* m_pNicknameEdit2;
    TQLineEdit* m_pHostEdit1;
    TQLineEdit* m_pHostEdit2;
    TQLineEdit* m_pUsernameEdit1;
    TQLineEdit* m_pUsernameEdit2;
    TQWidget* m_pPage3;
    TQLabel* m_pLabel3;
	KviPixmapSelector * m_pAvatarSelector;
    TQWidget* m_pPage4;
    TQCheckBox* m_pNotifyCheck;
    TQLabel* m_pNotifyNickLabel1;
    TQLabel* m_pNotifyNickLabel2;
    TQLabel* m_pLabel4;
    TQLineEdit* m_pNotifyNickEdit1;
    TQLineEdit* m_pNotifyNickEdit2;
    TQWidget* m_pPage5;
    TQLabel* m_pTextLabel5;

	KviPixmap * m_pAvatar;
protected:
	virtual void showEvent(TQShowEvent *e);
	virtual void accept();
	virtual void reject();
protected slots:
	void realNameChanged(const TQString &str);
	void maskChanged(const TQString &str);
	void notifyNickChanged(const TQString &);
	void notifyCheckToggled(bool);
};

#endif // _WIZARD_H_
