#ifndef _KVI_SCRIPTEDITOR_H_
#define _KVI_SCRIPTEDITOR_H_

//
//   File : kvi_scripteditor.h
//   Creation date : Sun Mar 28 1999 16:11:48 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

#include "kvi_settings.h"
#include <tqwidget.h>
#include <tqlineedit.h>
#include "kvi_qcstring.h"

//
// This is the basic interface of a script editor widget
//
// Actually the REAL script editor is implemented in an
// external module called "libkvieditor", and it is a really
// huge class.
// The constructor of this thing is protected: forget
// about instantiating it directly
//


class KVIRC_API KviScriptEditor : public TQWidget
{
	Q_OBJECT
  TQ_OBJECT
protected:
	KviScriptEditor(TQWidget * par);
	~KviScriptEditor();
protected:
	TQLineEdit * m_pFindLineedit;
public:
	virtual void setText(const char * txt);
	virtual void setText(const KviTQCString &txt);
	virtual void setText(const TQString &txt);
	virtual void getText(KviTQCString &txt);
	virtual void getText(TQString &txt);
	virtual void setInfoText(const TQString &text);
	virtual void setFindText(const TQString &text);
	virtual void setCursorPosition(TQPoint);
	virtual TQPoint getCursor();
	virtual void setFindLineeditReadOnly(bool b);
	virtual bool isModified();

	static KviScriptEditor * getDummyEditor(TQWidget * par);
	static KviScriptEditor * createInstance(TQWidget * par);
	static void destroyInstance(KviScriptEditor * e);
};


#endif //!_KVI_SCRIPTEDITOR_H_
