//
//   File : kvi_filedialog.cpp
//   Creation date : Mon Nov 20 2000 12:20:42 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
#define __KVIRC__
#include "kvi_filedialog.h"
#include "kvi_mediatype.h"
#include "kvi_iconmanager.h"
#include "kvi_locale.h"
#include "kvi_app.h"
#include "kvi_fileutils.h"
#include "kvi_frame.h"
#include "kvi_qstring.h"

#include <tqdir.h>
#include "kvi_tal_tooltip.h"
#include <tqmessagebox.h>

extern KviMediaManager * g_pMediaManager;


KviFileDialog::KviFileDialog(const TQString &dirName, const TQString &filter,
					TQWidget *parent, const char *name, bool modal)
: KviTalFileDialog(dirName,filter,parent,name,modal)
{

	setIcon(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_FOLDER)));

}

KviFileDialog::~KviFileDialog()
{
}


/*
void KviFileDialog::goKvirc()
{

	KviStr tmp;
	g_pApp->getLocalKvircDirectory(tmp,KviApp::None);
	setDir(TQDir(tmp.ptr()));

}

void KviFileDialog::goHome()
{

	setDir(TQDir::home());

}
*/



bool KviFileDialog::askForOpenFileName(TQString &buffer,const TQString &caption,const TQString &initial,const TQString &filter,bool showHidden, bool showNative,TQWidget* parent)
{
#ifdef COMPILE_ON_WINDOWS
	if(showNative)
	{
		buffer=TQFileDialog::getOpenFileName(initial,filter,parent,"open_file_name_dialog",caption);
		KviFileUtils::adjustFilePath(buffer);
		return !buffer.isEmpty();
	}
#endif
	KviFileDialog * d = new KviFileDialog(initial,filter,parent,"open_file_name_dialog",true);
	d->setCaption(caption);
	d->setMode(TQFileDialog::ExistingFile);
	//d->setShowHiddenFiles(showHidden);
	if(d->exec() == TQDialog::Accepted)
	{
		buffer = d->selectedFile();
		KviFileUtils::adjustFilePath(buffer);
		delete d;
		return !buffer.isEmpty();
	}
	delete d;
	return false;
}


bool KviFileDialog::askForSaveFileName(TQString &buffer,const TQString & caption,const TQString &initial,const TQString &filter,bool showHidden,bool bConfirmOverwrite,bool showNative,TQWidget* parent)
{
	#ifdef COMPILE_ON_WINDOWS
	if (showNative)
	{
		while (1)
		{
			buffer=TQFileDialog::getSaveFileName(initial,filter,parent,"save_file_name_dialog",caption);
			KviFileUtils::adjustFilePath(buffer);
			//return !buffer.isEmpty();
			if(buffer.isEmpty()) return false;
			if(!bConfirmOverwrite) return true;
			// Check for the file existence
			if(!KviFileUtils::fileExists(buffer)) return true;
			TQString tmp;
			KviTQString::sprintf(tmp,__tr2qs("The file %s already exists.<br>Do you wish to overwrite it?"),buffer.utf8().data());
			switch(TQMessageBox::information(parent,__tr2qs("File Exists - KVIrc"),tmp,TQMessageBox::Yes,TQMessageBox::No | TQMessageBox::Default,TQMessageBox::Cancel | TQMessageBox::Escape))
			{
					case TQMessageBox::Cancel: return false; break;
					case TQMessageBox::Yes:    return true;  break;
			}
			
		} 
		
		
	}
	#endif

	
	KviFileDialog * d = new KviFileDialog(initial,filter,parent,"save_file_name_dialog",true);
	d->setCaption(caption);
	d->setMode(TQFileDialog::AnyFile);
	//d->setShowHiddenFiles(showHidden);

	while(d->exec() == TQDialog::Accepted)
	{
		buffer = d->selectedFile();
		KviFileUtils::adjustFilePath(buffer);

		if(!buffer.isEmpty())
		{
			if(!bConfirmOverwrite)
			{
				delete d;
				return true;
			}
			// Check for the file existence
			if(KviFileUtils::fileExists(buffer))
			{
				TQString tmp;
				KviTQString::sprintf(tmp,__tr2qs("The file %s already exists.<br>Do you wish to overwrite it?"),buffer.utf8().data());
				switch(TQMessageBox::information(d,__tr2qs("File Exists - KVIrc"),tmp,TQMessageBox::Yes,TQMessageBox::No | TQMessageBox::Default,TQMessageBox::Cancel | TQMessageBox::Escape))
				{
					case TQMessageBox::Cancel: delete d; return false; break;
					case TQMessageBox::Yes:    delete d; return true;  break;
				}
			} else {
				delete d;
				return true; // ok...file not exists
			}
		} else {
			delete d;
			return false; // empty buffer
		}
	}

	delete d;
	return false;
	
}

bool KviFileDialog::askForDirectoryName(TQString &buffer,const TQString & caption,const TQString & initial,const char * filter,bool showHidden,bool showNative,TQWidget* parent)
{
#ifdef COMPILE_ON_WINDOWS
	if(showNative)
	{
		buffer = TQFileDialog::getExistingDirectory(initial,parent,"open_file_name_dialog",caption);
		return !buffer.isEmpty();
	}
#else
	#ifdef COMPILE_KDE_SUPPORT
		// the KDE based dir selection dialog is now quite nice
		buffer = KFileDialog::getExistingDirectory(initial,parent,caption);
		return !buffer.isEmpty();
	#endif
#endif

	KviFileDialog * d = new KviFileDialog(initial,
		filter,parent,"directory_name_dialog",true);
	d->setCaption(caption);
	d->setMode(TQFileDialog::Directory);
	//d->setShowHiddenFiles(showHidden);
	if(d->exec() == TQDialog::Accepted)
	{
		buffer = d->selectedFile();
		KviFileUtils::adjustFilePath(buffer);
		delete d;
		return !buffer.isEmpty();
	}
	delete d;

	return false;
}


bool KviFileDialog::askForOpenFileNames(TQStringList &buffer,const TQString & caption,const TQString & initial,const char * filter,bool showHidden,bool showNative,TQWidget* parent)
{
	#ifdef COMPILE_ON_WINDOWS
	if (showNative)
	{
		buffer=TQFileDialog::getOpenFileNames(filter,initial,parent,"open_file_name_dialog",caption);
		return (buffer.count()>0);
	}
	
	#endif
	KviFileDialog * d = new KviFileDialog(initial,filter ? TQString(filter) : TQString(),parent,"open_file_names_dialog",true);
	d->setCaption(caption);
	d->setMode(TQFileDialog::ExistingFiles);
	//d->setShowHiddenFiles(showHidden);	
	if(d->exec() == TQDialog::Accepted)
	{
		buffer = d->selectedFiles();
		delete d;
		return (buffer.count() > 0);
	}
	delete d;
	return false;
}


#include "kvi_filedialog.moc"
