//=============================================================================
//
//   File : kvi_tal_filedialog.coo
//   Creation date : Thu Sep 11 2003 04:09:24 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2003-2007 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#define __KVILIB__


#include "kvi_tal_filedialog.h"

#ifdef COMPILE_USE_QT4

	#include <tqdir.h>

	KviTalFileDialog::KviTalFileDialog(const TQString &dirName,const TQString &filter,TQWidget *parent,const char *name,bool modal)
	: TQFileDialog(parent,"",dirName,filter)
	{
		setModal(modal);
	}

	KviTalFileDialog::~KviTalFileDialog()
	{
	}

	void KviTalFileDialog::setFileMode(FileMode m)
	{
		switch(m)
		{
			case AnyFile:
				TQFileDialog::setFileMode(TQFileDialog::AnyFile);
			break;
			case ExistingFile:
				TQFileDialog::setFileMode(TQFileDialog::ExistingFile);
			break;
			case ExistingFiles:
				TQFileDialog::setFileMode(TQFileDialog::ExistingFiles);
			break;
			case Directory:
				TQFileDialog::setFileMode(TQFileDialog::Directory);
			break;
			case DirectoryOnly:
				TQFileDialog::setFileMode(TQFileDialog::DirectoryOnly);
			break;
			default:
				TQFileDialog::setFileMode(TQFileDialog::AnyFile);
			break;
		}
	}
	
	void KviTalFileDialog::setDirectory(const TQString &szDirectory)
	{
		TQFileDialog::setDirectory(szDirectory);
	}


	#include "kvi_tal_filedialog_qt4.moc"

#else

	#ifdef COMPILE_KDE_SUPPORT
	
		KviTalFileDialog::KviTalFileDialog(const TQString &dirName,const TQString &filter,TQWidget *parent,const char *name,bool modal)
		: KFileDialog(dirName,filter,parent,name,modal)
		{
			clearWFlags(WDestructiveClose);
		}
	
		KviTalFileDialog::~KviTalFileDialog()
		{
		}
		
		void KviTalFileDialog::setFileMode(FileMode m)
		{
			switch(m)
			{
				case AnyFile:
					setMode(KFile::File | KFile::LocalOnly);
					setOperationMode(Saving);
				break;
				case ExistingFile:
					setMode(KFile::File | KFile::ExistingOnly | KFile::LocalOnly);
					setOperationMode(Opening);
				break;
				case ExistingFiles:
					setMode(KFile::Files | KFile::ExistingOnly | KFile::LocalOnly);
					setOperationMode(Opening);
				break;
				case Directory:
					setMode(KFile::Directory);
				break;
				case DirectoryOnly:
					setMode(KFile::Directory);
				break;
				default:
					setMode(KFile::File | KFile::LocalOnly);
					setOperationMode(Saving);
				break;
			}
		}
		
		void KviTalFileDialog::setDirectory(const TQString &szDirectory)
		{
			setURL(szDirectory);
		}
	
	
		#include "kvi_tal_filedialog_kde.moc"
	
	#else
	
		#include <tqdir.h>
	
		KviTalFileDialog::KviTalFileDialog(const TQString &dirName,const TQString &filter,TQWidget *parent,const char *name,bool modal)
		: TQFileDialog(dirName,filter,parent,name,modal)
		{
			clearWFlags(WDestructiveClose);
		}
	
		KviTalFileDialog::~KviTalFileDialog()
		{
		}
	
		void KviTalFileDialog::setFileMode(FileMode m)
		{
			switch(m)
			{
				case AnyFile:
					setMode(TQFileDialog::AnyFile);
				break;
				case ExistingFile:
					setMode(TQFileDialog::ExistingFile);
				break;
				case ExistingFiles:
					setMode(TQFileDialog::ExistingFiles);
				break;
				case Directory:
					setMode(TQFileDialog::Directory);
				break;
				case DirectoryOnly:
					setMode(TQFileDialog::DirectoryOnly);
				break;
				default:
					setMode(TQFileDialog::AnyFile);
				break;
			}
		}
		
		void KviTalFileDialog::setDirectory(const TQString &szDirectory)
		{
			setDir(TQDir(szDirectory));
		}
	
	
		#include "kvi_tal_filedialog_qt.moc"
	
	#endif
#endif
