/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
 

#include <tqlayout.h>
#include <tqvbox.h>
#include <tqhbox.h>
#include <tqtooltip.h>
#include <tqlabel.h>
#include <tqwhatsthis.h>

// KDE includes
#include <klocale.h>
#include <kfiledialog.h>
#include <kdialogbase.h>
#include <kurl.h>
#include <kmessagebox.h>
#include <kiconloader.h>
#include <kdebug.h>

#include "globals.h"

#include "specificFileList.h"


SpecificFileList::SpecificFileList(TQWidget* parent, TQString description) :
	FileList(parent, description)
	{


	changeItem=new TQPushButton(SmallIconSet("colorize"), i18n("&Change Status..."), buttons);
	connect(changeItem, TQT_SIGNAL(clicked()), this, TQT_SLOT(changeItemType()));
	TQToolTip::add(changeItem, i18n("Change the level of the current file(s)"));
	TQWhatsThis::add(changeItem, i18n("<qt>Changes the level of the current file(s). See KSystemLog documentation for more information about each log level.</qt>"));
	
	fileListMenu->insertSeparator();
	fileListMenu->insertItem(SmallIcon("colorize"), i18n("&Change Status"), this, TQT_SLOT(changeItemType()));

	
	changeItem->setEnabled(false);
	
}

SpecificFileList::~SpecificFileList() {

}

void SpecificFileList::insertItem(TQString& item) {
	this->insertItem(Globals::informationLogLevel, item);
}

void SpecificFileList::insertItem(LogLevel* level, TQString& item) {
	fileList->insertItem(level->pixmap, item);
	levels[fileList->item(fileList->count()-1)]=level->id;
}

void SpecificFileList::removeItem(int id) {
	levels.erase(fileList->item(id));
	fileList->removeItem(id);
}

void SpecificFileList::addItem() {
	//Open a standard Filedialog
	KURL::List urlList;
	urlList=KFileDialog::getOpenURLs(DEFAULT_FOLDER, "*|" + i18n("All Files (*)") + "\n*.log|" + i18n("Log Files (*.log)"), this, i18n("Choose Log File"));
	
	KURL url;
	KURL::List::iterator it;
	
	for(it=urlList.begin(); it!=urlList.end(); ++it) {
		url=*it;
		if (isValidFile(url)) {
			TQString path=url.path();
			this->insertItem(Globals::informationLogLevel, path);
		}
	}
	
	emit fileListChanged(fileList->count());
}

bool SpecificFileList::updateButtons() {
	bool value=FileList::updateButtons();
	
	//If nothing is selected, disabled special buttons
	changeItem->setEnabled(value);
	
	return(value);
}

void SpecificFileList::changeItemType() {
	kdDebug() << "Change Item type" << endl;
	
	KDialogBase dialog(this, "select_type", true, i18n("Selecting File Type"), KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok);
	
	TQVBox topContents(&dialog);
	topContents.setSpacing(8);
	topContents.setMinimumSize(TQSize(100, 230));
	
	TQLabel text(i18n("Please select the type of this file:"), &topContents);
	KListBox choiceList(&topContents, "type_list");
	
	TQToolTip::add(choiceList.viewport(), i18n("List of existing log levels"));
	TQWhatsThis::add(choiceList.viewport(), i18n("<qt>This is the list of all existing log levels. Please select one of them to be used for the selected files of the list.</qt>"));
	
	//TODO Move this code to a specific class
	//connect(&choiceList, TQT_SIGNAL(doubleClicked(TQListBoxItem*)), &dialog, TQT_SLOT(okClicked()));
	
	TQPtrListIterator<LogLevel> itLevel(Globals::logLevels);
	LogLevel* level=itLevel.current();

	while (level!=NULL) {
		choiceList.insertItem(level->pixmap, level->name);
		
		++itLevel;
		level=itLevel.current();
	}
	
	text.setBuddy(&choiceList);
	
	dialog.setMainWidget(&topContents);
	dialog.enableButtonSeparator(false);

	int choice=dialog.exec();
	
	if (choice==TQDialog::Accepted) {
	
		int count=fileList->count();
		
		int selected=-1;
		if (choiceList.selectedItem()!=NULL)
			selected=choiceList.index(choiceList.selectedItem());
		
		if (selected!=-1) {
			for (int i=0; i<count; i++) {
				if (fileList->isSelected(i)) {
					levels.erase(fileList->item(i));
					fileList->changeItem(*(choiceList.pixmap(selected)), fileList->text(i), i);
					levels[fileList->item(i)]=selected;
				}
			}
			emit fileListChanged(fileList->numRows());
		}
		
	}
}


LogLevel* SpecificFileList::getLevel(int i) {
	return(Globals::logLevels.at(levels[fileList->item(i)]));

}

void SpecificFileList::saveConfig(TQStringList& filePathList, TQValueList<int>& logLevelList) {
	int count=fileList->count();
	
	for (int i=0; i<count; i++) {
		logLevelList.push_back(this->getLevel(i)->id);
		filePathList.push_back(this->getText(i));
	}

}

void SpecificFileList::readConfig(TQStringList& stringList, TQValueList<int>& valueList) {

	//A little security test
	if (stringList.size() != valueList.size()) {
		kdDebug() << i18n("The two arrays size are different, skipping the reading of generic paths.") << endl;
		return;
	}

	LogLevel* level;
	
	TQStringList::Iterator itString=stringList.begin();
	TQValueList<int>::Iterator itInt=valueList.begin();
	
	while(itString!=stringList.end()) {
		if (*itInt>=0 && *itInt<(int) Globals::logLevels.count())
			level=Globals::logLevels.at(*itInt);
		else
			level=Globals::informationLogLevel;
		
		//TODO Is it VERY useful to test if *itString is a real URL or not ?
		//if (!KURL(*itString).isValid())
		
		
		this->insertItem(level, *itString);
	
		itString++;
		itInt++;
	}
}


#include "specificFileList.moc"
