/***************************************************************************
                          sq_fileiconviewbase.cpp  -  description
                             -------------------
    begin                : ??? Feb 22 2005
    copyright            : (C) 2005 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tqdragobject.h>
#include <tqcursor.h>

#include <kglobalsettings.h>
#include <kaction.h>
#include <kfileitem.h>
#include <kio/job.h>
#include <konq_filetip.h>

#include "ksquirrel.h"
#include "sq_fileiconviewbase.h"
#include "sq_config.h"

SQ_FileIconViewBase::SQ_FileIconViewBase(TQWidget *parent, const char *name)
    : KFileIconView(parent, name)
{
    toolTip = new KonqFileTip(this);
    slotResetToolTip();

    disconnect(this, TQT_SIGNAL(onViewport()), this, 0);
    disconnect(this, TQT_SIGNAL(onItem(TQIconViewItem *)), this, 0);
    connect(this, TQT_SIGNAL(onViewport()), this, TQT_SLOT(slotRemoveToolTip()));
    connect(this, TQT_SIGNAL(onItem(TQIconViewItem *)), this, TQT_SLOT(slotShowToolTip(TQIconViewItem *)));
}

SQ_FileIconViewBase::~SQ_FileIconViewBase()
{
    slotRemoveToolTip();
}

void SQ_FileIconViewBase::slotResetToolTip()
{
    SQ_Config::instance()->setGroup("Fileview");

    toolTip->setOptions(true,
                        SQ_Config::instance()->readBoolEntry("tooltips_preview", false),
                        SQ_Config::instance()->readNumEntry("tooltips_lines", 6));
}

// Show extended tooltip for item under mouse cursor
void SQ_FileIconViewBase::slotShowToolTip(TQIconViewItem *item)
{
    SQ_Config::instance()->setGroup("Fileview");

    if(!SQ_Config::instance()->readBoolEntry("tooltips", false) ||
        (!KSquirrel::app()->isActiveWindow() && SQ_Config::instance()->readBoolEntry("tooltips_inactive", true)))
        return;

    // remove previous tootip and stop timer
    slotRemoveToolTip();

    KFileIconViewItem *fitem = dynamic_cast<KFileIconViewItem *>(item);

    if(!fitem) return;

    KFileItem *f = fitem->fileInfo();

    if(f) toolTip->setItem(f, fitem->rect(), fitem->pixmap());
}

bool SQ_FileIconViewBase::eventFilter(TQObject *o, TQEvent *e)
{
    if(TQT_BASE_OBJECT(o) == TQT_BASE_OBJECT(viewport()) || TQT_BASE_OBJECT(o) == TQT_BASE_OBJECT(this))
    {
        int type = e->type();

        if(type == TQEvent::Leave || type == TQEvent::FocusOut || type == TQEvent::Hide)
            slotRemoveToolTip();
    }

    return KFileIconView::eventFilter(o, e);
}

/*
 *  Remove tootip.
 */
void SQ_FileIconViewBase::slotRemoveToolTip()
{
    toolTip->setItem(0);
}

// Accept drag
void SQ_FileIconViewBase::dragEnterEvent(TQDragEnterEvent *e)
{
    e->accept(true);
}

/*
 *  Handle double clicks.
 */
void SQ_FileIconViewBase::contentsMouseDoubleClickEvent(TQMouseEvent *e)
{
    TQIconView::contentsMouseDoubleClickEvent(e);

    TQIconViewItem *item = findItem(e->pos());

    // double click on item
    if(item)
        emit doubleClicked(item, e->globalPos());

    // double click in viewport, lets invoke browser
    else
        emit invokeBrowser();
}

void SQ_FileIconViewBase::updateView(const KFileItem *i)
{
    KFileIconViewItem *item = viewItem(i);

    if(item)
        initItemMy(item, i, true);
}

KFileIconViewItem* SQ_FileIconViewBase::viewItem(const KFileItem *item)
{
    return item ? reinterpret_cast<KFileIconViewItem *>((void *)item->extraData(this)) : 0;
}

void SQ_FileIconViewBase::initItemMy(KFileIconViewItem *item, const KFileItem *i, bool upd)
{
    if(upd)
        item->setText(i->text(), true, true);

    // determine current sorting type
    TQDir::SortSpec spec = KFileView::sorting();

    if(spec & TQDir::Time)
        item->setKey(sortingKey((unsigned long)i->time(KIO::UDS_MODIFICATION_TIME), i->isDir(), spec));
    else if(spec & TQDir::Size)
        item->setKey(sortingKey(i->size(), i->isDir(), spec));
    else
        item->setKey(sortingKey(i->text(), i->isDir(), spec));
}

#include "sq_fileiconviewbase.moc"
