/***************************************************************************
                          sq_externaltool.h  -  description
                             -------------------
    begin                : ??? ??? 12 2004
    copyright            : (C) 2004 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SQ_EXTERNALTOOL_H
#define SQ_EXTERNALTOOL_H

#include <tqstring.h>
#include <tqobject.h>
#include <tqvaluevector.h>

#include <kfileitem.h>

class SQ_PopupMenu;

struct Tool
{
    Tool();
    Tool(const TQString &, const TQString &, const TQString &);

    TQString name, command;
    TQString icon;
};

/*
 *  Class which manages external tools. It store all available external tools
 *  in memory, and create popup menu where external tools been inserted.
 */

class SQ_ExternalTool : public TQObject, public TQValueVector<Tool>
{
    Q_OBJECT
  TQ_OBJECT

    public: 
        SQ_ExternalTool(TQObject *parent = 0);
        ~SQ_ExternalTool();

        /*
         *  Get pixmap, name or command of external tool.
         */
        TQString toolPixmap(const int i);
        TQString toolName(const int i);
        TQString toolCommand(const int i);

        void setItems(const KFileItemList &);

        /*
         *  Recreate current popop menu.
         */
        SQ_PopupMenu* newPopupMenu();

        /*
         *  Get current popup menu.
         */
        SQ_PopupMenu* constPopupMenu() const;

        /*
         *  Write tools to config file as TQStringLists
         */
        void writeEntries();

        static SQ_ExternalTool* instance() { return m_instance; }

    private slots:

        /*
         *  Invoked, when user executed popup menu with external tools.
         *  This slot will do some useful stuff.
         */
        void slotAboutToShowMenu();
        void slotActivateTool(int);

    private:
        /*
         *  Popup menu with all tools.
         */
        SQ_PopupMenu *menu;

        KFileItemList items;

        static SQ_ExternalTool *m_instance;
};

inline
void SQ_ExternalTool::setItems(const KFileItemList &itms)
{
    items = itms;
}

#endif
