/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** TQt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

void KLC::init()
{
    changed = false;

    listEnabled->setSorting(0);
    listEnabled->header()->hide();

    listDisabled->setSorting(0);
    listDisabled->header()->hide();

    lister = new KDirLister;
    connect(lister, TQT_SIGNAL(completed(const KURL &)), this, TQT_SLOT(slotCompleted(const KURL &)));
    connect(lister, TQT_SIGNAL(deleteItem(KFileItem *)), this, TQT_SLOT(slotDeleteItem(KFileItem *)));
    connect(lister, TQT_SIGNAL(newItems(const KFileItemList &)), this, TQT_SLOT(slotNewItems(const KFileItemList &)));

    base = KURL::fromPathOrURL(SQ_KLIBS);

    backup = base;
    backup.addPath("backup");

    backupDir = backup.path();
    
    KIO::NetAccess::mkdir(backup, this);

    TQTimer::singleShot(0, this, TQT_SLOT(slotLoad()));
}

void KLC::slotLoad()
{
    lister->openURL(base);
    lister->openURL(backup, true);
}

void KLC::destroy()
{
    delete lister;
}

void KLC::slotApply()
{
    changed = true;

    moveCodecs(true);
    moveCodecs(false);
}

void KLC::moveCodecs(bool e2d)
{
    KURL::List list;
    KURL codec;

    TQListViewItemIterator it(e2d ? listEnabled : listDisabled);
    TQCheckListItem *li;

    while((li = static_cast<TQCheckListItem *>(it.current())))
    {
        if(li->isOn())
        {
	    codec = e2d ? base : backup;
    	    codec.addPath(li->text());
	    list.append(codec);
        }

	++it;
    }

    KIO::Job *job = KIO::move(list, e2d ? backup : base);

    connect(job, TQT_SIGNAL(result(KIO::Job *)), this, TQT_SLOT(slotDelResult(KIO::Job *)));
}

void KLC::slotCompleted(const KURL &u)
{
    if(u == base)
    {
	listEnabled->setEnabled(true);
	listEnabled->setCurrentItem(listEnabled->firstChild());
    }
    else
    {
	listDisabled->setEnabled(true);
	listDisabled->setCurrentItem(listDisabled->firstChild());
    }
}

void KLC::slotNewItems(const KFileItemList &list)
{
    KFileItemListIterator it(list);
    KFileItem *fi;
    TQString soname = TQString::fromLatin1(".so.%1").arg(SQ_KL_VER);

    while((fi = it.current()))
    {
	if(fi->isFile() && fi->name().endsWith(soname))
	    new  TQCheckListItem(fi->url().directory().startsWith(backupDir) ? listDisabled:listEnabled, fi->name(), TQCheckListItem::CheckBox);

	++it;
    }
}

void KLC::slotDeleteItem(KFileItem *fi)
{
    TQListView *l = fi->url().directory().startsWith(backupDir) ? listDisabled:listEnabled;

    TQListViewItemIterator it(l);
    TQCheckListItem *li;
    TQListViewItem *li2;

    while((li = static_cast<TQCheckListItem *>(it.current())))
    {
        if(li->text() == fi->name())
        {
            li2 = li->itemBelow();

            if(!li2)
                li2 = li->itemAbove();

            delete li;

            l->setCurrentItem(li2);
            l->setSelected(li2, true);

            return;
        }

	++it;
    }
}

void KLC::slotDelResult(KIO::Job *job)
{
    if(job && job->error())
	job->showErrorDialog(this);
}

void KLC::closeEvent(TQCloseEvent *ev)
{
    TQString data;

    if(changed)
	kapp->dcopClient()->send("ksquirrel", "ksquirrel", "reload_codecs()", data);

    ev->accept();
}
