/***************************************************************************
                          timecontrol.h  -  description
                             -------------------
    begin                : Son Jan 12 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_TIMECONTROL_H
#define KRADIO_TIMECONTROL_H

#include <tqobject.h>
#include <tqtimer.h>

#include "../../src/include/alarm.h"
#include "../../src/include/plugins.h"
#include "../../src/include/timecontrol_interfaces.h"

// well, it has to be a TQObject :(  , but only for
// receiving TQTimer - timeouts

class TimeControl : public TQObject,
                    public PluginBase,
                    public ITimeControl
{
  Q_OBJECT
  TQ_OBJECT
protected:
    AlarmVector       m_alarms;
    Alarm const *     m_waitingFor;         // m_alarmTimer is exactly for this date/time

    int               m_countdownSeconds;   // in seconds
    TQDateTime         m_countdownEnd;

    TQTimer            m_alarmTimer;
    TQTimer            m_countdownTimer;

    mutable TQDateTime m_nextAlarm_tmp;      // used to recognize nextAlarm changes

public:
    TimeControl (const TQString &name);
    ~TimeControl();

    virtual TQString pluginClassName() const { return "TimeControl"; }

    virtual const TQString &name() const { return PluginBase::name(); }
    virtual       TQString &name()       { return PluginBase::name(); }

    virtual bool   connectI (Interface *i);
    virtual bool   disconnectI (Interface *i);

    // PluginBase

public:
    virtual void   saveState (KConfig *) const;
    virtual void   restoreState (KConfig *);

    virtual ConfigPageInfo  createConfigurationPage();
    virtual AboutPageInfo   createAboutPage();


    // ITimeControl Interface methods

RECEIVERS:
    bool setAlarms(const AlarmVector &sl);
    bool setCountdownSeconds(int n);
    bool startCountdown();
    bool stopCountdown();

ANSWERS:
    TQDateTime           getNextAlarmTime () const;
    const Alarm*        getNextAlarm () const;
    const AlarmVector & getAlarms () const { return m_alarms; }
    int                 getCountdownSeconds () const { return m_countdownSeconds; }
    TQDateTime           getCountdownEnd () const;


    // slots for receiving timeout messages of timers

protected slots:
    virtual void    slotQTimerAlarmTimeout();
    virtual void    slotQTimerCountdownTimeout();

};


#endif
