/****************************************************************************
** $Id: buttonflowtqlayout.h 471 2006-11-11 17:04:51Z emw $
**
** Definition of simple flow layout for custom layout example
**
** Created : 979899
**
** Copyright (C) 1997 by Trolltech AS.  All rights reserved.
**
** This file is part of an example program for TQt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
/**
   Modified 2002 by Klas Kalass (klas.kalass@gmx.de) for kradio
 */
#ifndef BUTTONFLOWLAYOUT_H
#define BUTTONFLOWLAYOUT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "../../src/include/utils.h"

#include <tqlayout.h>
#include <tqptrlist.h>

class ButtonFlowLayout : public TQLayout
{
public:
    ButtonFlowLayout( TQWidget *parent, int margin = 0, int spacing=-1,
                      const char *name=0 );

    ButtonFlowLayout( TQLayout* parentLayout, int spacing=-1, const char *name=0 );

    ButtonFlowLayout( int spacing=-1, const char *name=0 );

    ~ButtonFlowLayout();

    void addItem( TQLayoutItem *item);
    bool hasHeightForWidth() const;
    int heightForWidth( int ) const;
    TQSize sizeHint() const;
    TQSize minimumSize() const;
    TQSize minimumSize(const TQSize &r) const;  // minimumSize is dependent from width
    TQLayoutIterator iterator();
    TQSizePolicy::ExpandData expanding() const;

#ifdef USE_QT4
    QLAYOUT_REQUIRED_METHOD_DECLARATIONS
#endif // USE_QT4

protected:
    void setGeometry( const TQRect& );

private:
    int doLayout( const TQRect&, bool testonly = FALSE );
    TQPtrList<TQLayoutItem> list;
    int cached_width;
    int cached_hfw;
};

#endif
