/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Dialog for quick connection to an IRC network without adding a server in the Server List.
  begin:     Sat June 05 2004
  copyright: (C) 2004 by Michael Goettsche
  email:     mail@tuxipuxi.de
*/

#include "quickconnectdialog.h"
#include "konversationapplication.h"

#include <tqlayout.h>
#include <tqwhatsthis.h>
#include <tqlabel.h>
#include <tqcheckbox.h>

#include <klineedit.h>
#include <klocale.h>


QuickConnectDialog::QuickConnectDialog(TQWidget *parent)
:KDialogBase(parent, "quickconnect", true, i18n("Quick Connect"),
KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, true)
{
    TQWidget* page = new TQWidget(this);
    setMainWidget(page);

    TQGridLayout* layout = new TQGridLayout(page, 2, 4);
    layout->setSpacing(spacingHint());
    layout->setColStretch(1, 10);

    TQLabel* hostNameLabel = new TQLabel(i18n("&Server host:"), page);
    TQString hostNameWT = i18n("Enter the host of the network here.");
    TQWhatsThis::add(hostNameLabel, hostNameWT);
    hostNameInput = new KLineEdit(page);
    TQWhatsThis::add(hostNameInput, hostNameWT);
    hostNameLabel->setBuddy(hostNameInput);

    TQLabel* portLabel = new TQLabel(i18n("&Port:"), page);
    TQString portWT = i18n("The port that the IRC server is using.");
    TQWhatsThis::add(portLabel, portWT);
    portInput = new KLineEdit("6667", page );
    TQWhatsThis::add(portInput, portWT);
    portLabel->setBuddy(portInput);

    TQLabel* nickLabel = new TQLabel(i18n("&Nick:"), page);
    TQString nickWT = i18n("The nick you want to use.");
    TQWhatsThis::add(nickLabel, nickWT);
    nickInput = new KLineEdit(Preferences::nickname(0), page);
    TQWhatsThis::add(nickInput, nickWT);
    nickLabel->setBuddy(nickInput);

    TQLabel* passwordLabel = new TQLabel(i18n("P&assword:"), page);
    TQString passwordWT = i18n("If the IRC server requires a password, enter it here (most servers do not require a password.)");
    TQWhatsThis::add(passwordLabel, passwordWT);
    passwordInput = new KLineEdit(page);
    TQWhatsThis::add(passwordInput, passwordWT);
    passwordLabel->setBuddy(passwordInput);

    sslCheckBox = new TQCheckBox(page, "sslCheckBox");
    sslCheckBox->setText(i18n("&Use SSL"));

    layout->addWidget(hostNameLabel, 0, 0);
    layout->addWidget(hostNameInput, 0, 1);
    layout->addWidget(portLabel, 0, 2);
    layout->addWidget(portInput, 0, 3);

    layout->addWidget(nickLabel, 1, 0);
    layout->addWidget(nickInput, 1, 1);
    layout->addWidget(passwordLabel, 1, 2);
    layout->addWidget(passwordInput, 1, 3);

    layout->addWidget(sslCheckBox, 2, 0);

    hostNameInput->setFocus();

    setButtonOK(KGuiItem(i18n("C&onnect"),"connect_creating",i18n("Connect to the server")));
}

QuickConnectDialog::~QuickConnectDialog()
{
}

void QuickConnectDialog::slotOk()
{
    if (!hostNameInput->text().isEmpty() &&
        !portInput->text().isEmpty() &&
        !nickInput->text().isEmpty())
    {

        emit connectClicked(Konversation::PromptToReuseConnection,
                            hostNameInput->text().stripWhiteSpace(),
                            portInput->text(),
                            passwordInput->text(),
                            nickInput->text(),
                            "",
                            sslCheckBox->isChecked());
        delayedDestruct();
    }
}

#include "quickconnectdialog.moc"
