/*
  Copyright (c) 2005 by İsmail Dönmez <ismail@kde.org>

  *************************************************************************
  *                                                                       *
  * This program is free software; you can redistribute it and/or modify  *
  * it under the terms of the GNU General Public License as published by  *
  * the Free Software Foundation; either version 2 of the License, or     *
  * (at your option) any later version.                                   *
  *                                                                       *
  *************************************************************************

Based on the code by:
Copyright (C) 2002 Carsten Pfeiffer <pfeiffer@kde.org>

*/

#include "konvibookmarkhandler.h"
#include "konversationapplication.h"
#include "konversationmainwindow.h"
#include "connectionmanager.h"
#include "konvibookmarkmenu.h"

#include <tqstring.h>

#include <kpopupmenu.h>
#include <kstandarddirs.h>


KonviBookmarkHandler::KonviBookmarkHandler(KonversationMainWindow* mainWindow)
: TQObject( mainWindow, "KonviBookmarkHandler" ),
KBookmarkOwner(),
m_mainWindow(mainWindow)
{
    m_menu = static_cast<KPopupMenu*>(mainWindow->factory()->container("bookmarks", mainWindow));

    m_file = locate( "data", "konversation/bookmarks.xml" );

    if ( m_file.isEmpty() )
        m_file = locateLocal( "data", "konversation/bookmarks.xml" );

    if(!m_menu)
    {
        m_bookmarkMenu = 0;
        return;
    }

    KBookmarkManager *manager = KBookmarkManager::managerForFile( m_file, false);
    manager->setEditorOptions(kapp->caption(), false);
    manager->setUpdate( true );
    manager->setShowNSBookmarks( false );

    connect( manager, TQT_SIGNAL(changed(const TQString &,const TQString &)), TQT_SLOT(slotBookmarksChanged(const TQString &,const TQString &)));

    m_bookmarkMenu = new KonviBookmarkMenu( manager, this, m_menu, NULL, true );
}

KonviBookmarkHandler::~KonviBookmarkHandler()
{
    delete m_bookmarkMenu;
}

void KonviBookmarkHandler::slotEditBookmarks()
{
    KProcess proc;
    proc << TQString::fromLatin1("keditbookmarks");
    proc << "--nobrowser";
    proc << "--caption" << i18n("Konversation Bookmarks Editor");
    proc << m_file;
    proc.start(KProcess::DontCare);
}

void KonviBookmarkHandler::slotBookmarksChanged( const TQString &,
const TQString &)
{
    // This is called when someone changes bookmarks in konversation
    m_bookmarkMenu->slotBookmarksChanged("");
}

void KonviBookmarkHandler::openBookmarkURL(const TQString& url, const TQString& /* title */)
{
    KonversationApplication* konvApp = static_cast<KonversationApplication*>(kapp);
    konvApp->getConnectionManager()->connectTo(Konversation::SilentlyReuseConnection, url);
}

TQString KonviBookmarkHandler::currentURL() const
{
    return m_mainWindow->currentURL(true);
}

TQString KonviBookmarkHandler::currentTitle() const
{
    return m_mainWindow->currentTitle();
}

#include "konvibookmarkhandler.moc"
