/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2004 Peter Simonsson <psn@linux.se>
  Copyright (C) 2006-2008 Eike Hein <hein@kde.org>
*/

#include "common.h"
#include "konversationapplication.h"
#include "config/preferences.h"

#include <tqcstring.h>
#include <tqstring.h>
#include <tqregexp.h>
#include <tqpixmap.h>
#include <tqbitmap.h>
#include <tqpainter.h>
#include <klocale.h>


namespace Konversation
{

    #include "guess_ja.cpp"
    #include "unicode.cpp"

    static TQRegExp colorRegExp("((\003([0-9]|0[0-9]|1[0-5])(,([0-9]|0[0-9]|1[0-5])|)|\017)|\x02|\x09|\x13|\x16|\x1f)");
    static TQRegExp urlPattern("((www\\.(?!\\.)|(fish|irc|(f|sf|ht)tp(|s))://)(\\.?[\\d\\w/,\\':~\\?=;#@\\-\\+\\%\\*\\{\\}\\!\\(\\)]|&)+)|"
        "([-.\\d\\w]+@[-.\\d\\w]{2,}\\.[\\w]{2,})");
    static TQRegExp tdlPattern("(.*)\\.(\\w+),$");

    TQString removeIrcMarkup(const TQString& text)
    {
        TQString escaped = text;
        // Escape text decoration
        escaped.remove(colorRegExp);

        // Remove Mirc's 0x03 characters too, they show up as rectangles
        escaped.remove(TQChar(0x03));

        return escaped;
    }

    TQString tagURLs(const TQString& text, const TQString& fromNick, bool useCustomColor)
    {
        // TQTime timer;
        // timer.start();

        TQString filteredLine = text;
        TQString linkColor = Preferences::color(Preferences::Hyperlink).name();
        TQString link;
        TQString insertText;
        int pos = 0;
        int urlLen = 0;
        TQString href;

        if(useCustomColor)
        {
            link = "<font color=\""+linkColor+"\"><a href=\"#%1\">%2</a></font>";
        }
        else
        {
            link = "<a href=\"#%1\">%2</a>";
        }

        if(filteredLine.contains("#"))
        {
            TQRegExp chanExp("(^|\\s|^\"|\\s\"|,|'|\\(|\\:|!|@|%|\\+)(#[^,\\s;\\)\\:\\/\\(\\<\\>]*[^.,\\s;\\)\\:\\/\\(\"\''\\<\\>])");
            while((pos = chanExp.search(filteredLine, pos)) >= 0)
            {
                href = chanExp.cap(2);
                urlLen = href.length();
                pos += chanExp.cap(1).length();

                // HACK:Use space as a placeholder for \ as TQt tries to be clever and does a replace to / in urls in TQTextEdit
                insertText = link.arg(TQString(href).replace('\\', " "), href);
                filteredLine.replace(pos, urlLen, insertText);
                pos += insertText.length();
            }
        }

        pos = 0;
        urlLen = 0;

        urlPattern.setCaseSensitive(false);
        TQString protocol;

        if(useCustomColor)
        {
            link = "<font color=\"" + linkColor + "\"><u><a href=\"%1%2\">%3</a></u></font>";
        }
        else
        {
            link = "<u><a href=\"%1%2\">%3</a></u>";
        }

        while((pos = urlPattern.search(filteredLine, pos)) >= 0)
        {
            TQString append;

            // check if the matched text is already replaced as a channel
            if ( filteredLine.findRev( "<a", pos ) > filteredLine.findRev( "</a>", pos ) )
            {
                ++pos;
                continue;
            }

            protocol="";
            urlLen = urlPattern.matchedLength();
            href = filteredLine.mid( pos, urlLen );

            // Don't consider trailing comma part of link.
            if (href.right(1) == ",")
            {
                href.truncate(href.length()-1);
                append = ',';
            }

            // Don't consider trailing semicolon part of link.
            if (href.right(1) == ";")
            {
                href.truncate(href.length()-1);
                append = ';';
            }

            // Don't consider trailing closing parenthesis part of link when
            // there's an opening parenthesis preceding the beginning of the
            // URL or there is no opening parenthesis in the URL at all.
            if (href.right(1) == ")" && (filteredLine.mid(pos-1,1) == "(" || !href.contains("(")))
            {
                href.truncate(href.length()-1);
                append.prepend(")");
            }

            // TQt doesn't support (?<=pattern) so we do it here
            if((pos > 0) && filteredLine[pos-1].isLetterOrNumber())
            {
                pos++;
                continue;
            }

            if (urlPattern.cap(1).startsWith("www.", false))
                protocol = "http://";
            else if (urlPattern.cap(1).isEmpty())
                protocol = "mailto:";

            // Use \x0b as a placeholder for & so we can readd them after changing all & in the normal text to &amp;
            // HACK Replace % with \x03 in the url to keep TQt from doing stupid things
            insertText = link.arg(protocol, TQString(href).replace('&', "\x0b").replace('%', "\x03"), href) + append;
            filteredLine.replace(pos, urlLen, insertText);
            pos += insertText.length();
            KonversationApplication::instance()->storeUrl(fromNick, href);
        }

        // Change & to &amp; to prevent html entities to do strange things to the text
        filteredLine.replace('&', "&amp;");
        filteredLine.replace("\x0b", "&");

        // kdDebug() << "Took (msecs) : " << timer.elapsed() << " for " << filteredLine << endl;

        return filteredLine;
    }

    //TODO: there's room for optimization as pahlibar said. (strm)

    // the below two functions were taken from kopeteonlinestatus.cpp.
    TQBitmap overlayMasks( const TQBitmap *under, const TQBitmap *over )
    {
        if ( !under && !over ) return TQBitmap();
        if ( !under ) return *over;
        if ( !over ) return *under;

        TQBitmap result = *under;
        bitBlt( &result, 0, 0, over, 0, 0, over->width(), over->height(), TQt::OrROP );
        return result;
    }

    TQPixmap overlayPixmaps( const TQPixmap &under, const TQPixmap &over )
    {
        if ( over.isNull() ) return under;

        TQImage imResult; imResult=under;
        TQImage imOver; imOver=over;
        TQPixmap result;

        bitBlt(&imResult,0,0,&imOver,0,0,imOver.width(),imOver.height(),0);
        result=imResult;
        return result;
    }

}
