/*
   $Id: main.h 466447 2005-10-02 17:54:10Z zander $
   This file is part of the KDE project
   Copyright (C) 2001,2002 Daniel Naber <daniel.naber@t-online.de>
*/
/***************************************************************************
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef __main_h__
#define __main_h__

#include <tqapplication.h>
#include <tqcombobox.h>
#include <tqgroupbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqlistbox.h>
#include <tqobject.h>
#include <tqregexp.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqtabdialog.h>
#include <tqtabwidget.h>
#include <tqtextbrowser.h>
#include <tqtooltip.h>
#include <tqwidget.h>
#include <tqvbox.h>

#include <kapplication.h>
#include <kcombobox.h>
#include <kconfig.h>
#include <kcursor.h>
#include <kdatatool.h>
#include <kdebug.h>
#include <kdialogbase.h>
#include <kgenericfactory.h>
#include <klibloader.h>
#include <klineedit.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kprocess.h>
#include <kpushbutton.h>
#include <krun.h>
#include <kstandarddirs.h>
#include <kurl.h>

class TQToolButton;

class Thesaurus : public KDataTool
{
    Q_OBJECT
  TQ_OBJECT

public:
    Thesaurus(TQObject* parent, const char* name, const TQStringList &);
    ~Thesaurus();
    virtual bool run(const TQString& command, void* data,
        const TQString& datatype, const TQString& mimetype);

protected slots:
    void slotChangeLanguage();

    void slotFindTerm();
    void slotFindTerm(const TQString &term, bool add_to_history = true);

    void slotUpdateNavButtons();
    void slotGotoHistory(int index);

    void slotSetReplaceTerm(TQListBoxItem *item);
    void slotSetReplaceTerm(const TQString &term);

    void slotBack();
    void slotForward();

    void thesExited(KProcess *proc);
    void receivedThesStdout(KProcess *proc, char *result, int len);
    void receivedThesStderr(KProcess *proc, char *result, int len);

    void wnExited(KProcess *proc);
    void receivedWnStdout(KProcess *proc, char *result, int len);
    void receivedWnStderr(KProcess *proc, char *result, int len);

protected:
    enum Mode {grep, other};
    void findTerm(const TQString &term);
    void findTermThesaurus(const TQString &term);
    void findTermWordnet(const TQString &term);
    TQString formatLine(TQString l);

/** 
 * Sort a list case insensitively.
 * Be careful: @p list is modified
 * TODO: use ksortablevaluelist?
 */
    TQStringList sortTQStringList(TQStringList list);
    void setCaption();

    TQString m_no_match;

    int m_history_pos;

    bool m_replacement;        // does this dialog offer a replace button etc.?

    KConfig *m_config;

    KProcess *m_thesproc;
    TQString m_thesproc_stdout;
    TQString m_thesproc_stderr;

    KProcess *m_wnproc;
    TQString m_wnproc_stdout;
    TQString m_wnproc_stderr;

    Mode m_mode;

    TQFrame *m_page;
    TQVBoxLayout *m_top_layout;

    KDialogBase *m_dialog;
    TQTabWidget *m_tab;
    TQVBox *vbox;
    TQVBox *vbox2;

    TQToolButton *m_back;
    TQToolButton *m_forward;
    KPushButton *m_lang;

    KPushButton *m_search;
    KHistoryCombo *m_edit;
    TQLabel *m_edit_label;

    TQLabel *m_replace_label;
    KLineEdit *m_replace;

    TQString m_data_file;

    // WordNet:
    TQTextBrowser *m_resultbox;
    TQComboBox *m_combobox;

    // Thesaurus:
    TQGroupBox *grpbox_syn;
    TQListBox *m_thes_syn;
    TQGroupBox *grpbox_hyper;
    TQListBox *m_thes_hyper;
    TQGroupBox *grpbox_hypo;
    TQListBox *m_thes_hypo;
};

#endif
