/* This library is distributed under the conditions of the GNU LGPL.
 * WMF Metafile Structures
 * Author: 2002/2003 thierry lorthiois
 */
#ifndef _KOWMFSTRUCT_H_
#define _KOWMFSTRUCT_H_

#include <tqglobal.h>
#include <tqnamespace.h>

#define APMHEADER_KEY 0x9AC6CDD7
#define ENHMETA_SIGNATURE       0x464D4520

struct WmfMetaHeader
{
  TQ_UINT16  fileType;      // Type of metafile (0=memory, 1=disk)
  TQ_UINT16  headerSize;    // always 9
  TQ_UINT16  version;
  TQ_UINT32  fileSize;      // Total size of the metafile in WORDs
  TQ_UINT16  numOfObjects;    // Maximum Number of objects in the stack
  TQ_UINT32  maxRecordSize;   // The size of largest record in WORDs
  TQ_UINT16  numOfParameters; // not used (always 0)
};


struct WmfPlaceableHeader
{
  TQ_UINT32  key;        // Magic number (always 9AC6CDD7h)
  TQ_UINT16  handle;     // Metafile HANDLE number (always 0)
  TQ_INT16   left;       // Left coordinate in metafile units
  TQ_INT16   top;
  TQ_INT16   right;
  TQ_INT16   bottom;
  TQ_UINT16  inch;       // Number of metafile units per inch
  TQ_UINT32  reserved;
  TQ_UINT16  checksum;   // Checksum value for previous 10 WORDs
};


struct WmfEnhMetaHeader
{
  TQ_UINT32  recordType;       // Record type (is always 00000001h)
  TQ_UINT32  recordSize;       // Record size in bytes.  This may be greater
                              // than the sizeof( ENHMETAHEADER ).
  TQ_INT32   boundsLeft;       // Inclusive-inclusive bounds in device units
  TQ_INT32   boundsTop;
  TQ_INT32   boundsRight;
  TQ_INT32   boundsBottom;
  TQ_INT32   frameLeft;        // Inclusive-inclusive Picture Frame
  TQ_INT32   frameTop;
  TQ_INT32   frameRight;
  TQ_INT32   frameBottom;
  TQ_UINT32  signature;        // Signature.  Must be ENHMETA_SIGNATURE.
  TQ_UINT32  version;          // Version number
  TQ_UINT32  size;             // Size of the metafile in bytes
  TQ_UINT32  numOfRecords;     // Number of records in the metafile
  TQ_UINT16  numHandles;       // Number of handles in the handle table
  // Handle index zero is reserved.
  TQ_UINT16  reserved;         // always 0
  TQ_UINT32  sizeOfDescription;   // Number of chars in the unicode description string
                                 // This is 0 if there is no description string
  TQ_UINT32  offsetOfDescription; // Offset to the metafile description record.
                                 // This is 0 if there is no description string
  TQ_UINT32  numPaletteEntries;   // Number of color palette entries
  TQ_INT32   widthDevicePixels;   // Size of the reference device in pixels
  TQ_INT32   heightDevicePixels;
  TQ_INT32   widthDeviceMM;       // Size of the reference device in millimeters
  TQ_INT32   heightDeviceMM;
};


struct WmfMetaRecord
{
  TQ_UINT32  size;         // Total size of the record in WORDs
  TQ_UINT16  function;     // Record function number
  TQ_UINT16  param[ 1 ];   // TQ_UINT16 array of parameters
};


struct WmfEnhMetaRecord
{
  TQ_UINT32  function;     // Record function number
  TQ_UINT32  size;         // Record size in bytes
  TQ_UINT32  param[ 1 ];   // TQ_UINT32 array of parameters
};

// Static data
    static const struct OpTab
    {
        TQ_UINT32  winRasterOp;
        TQt::RasterOp  qtRasterOp;
    } koWmfOpTab32[] =
    {
        { 0x00CC0020, TQt::CopyROP },
        { 0x00EE0086, TQt::OrROP },
        { 0x008800C6, TQt::AndROP },
        { 0x00660046, TQt::XorROP },
        { 0x00440328, TQt::AndNotROP },
        { 0x00330008, TQt::NotCopyROP },
        { 0x001100A6, TQt::NandROP },
        { 0x00C000CA, TQt::CopyROP },
        { 0x00BB0226, TQt::NotOrROP },
        { 0x00F00021, TQt::CopyROP },
        { 0x00FB0A09, TQt::CopyROP },
        { 0x005A0049, TQt::CopyROP },
        { 0x00550009, TQt::NotROP },
        { 0x00000042, TQt::ClearROP },
        { 0x00FF0062, TQt::SetROP }
    };

    static const TQt::RasterOp koWmfOpTab16[] =
    {
        TQt::CopyROP,
        TQt::ClearROP, TQt::NandROP, TQt::NotAndROP, TQt::NotCopyROP,
        TQt::AndNotROP, TQt::NotROP, TQt::XorROP, TQt::NorROP,
        TQt::AndROP, TQt::NotXorROP, TQt::NopROP, TQt::NotOrROP,
        TQt::CopyROP, TQt::OrNotROP, TQt::OrROP, TQt::SetROP
    };

    static const Qt::BrushStyle koWmfHatchedStyleBrush[] =
    {
        Qt::HorPattern,
        Qt::VerPattern,
        Qt::FDiagPattern,
        Qt::BDiagPattern,
        Qt::CrossPattern,
        Qt::DiagCrossPattern
    };

    static const Qt::BrushStyle koWmfStyleBrush[] =
    { Qt::SolidPattern,
      Qt::NoBrush,
      Qt::FDiagPattern,   /* hatched */
      Qt::Dense4Pattern,  /* should be custom bitmap pattern */
      Qt::HorPattern,     /* should be BS_INDEXED (?) */
      Qt::VerPattern,     /* should be device-independent bitmap */
      Qt::Dense6Pattern,  /* should be device-independent packed-bitmap */
      Qt::Dense2Pattern,  /* should be BS_PATTERN8x8 */
      Qt::Dense3Pattern   /* should be device-independent BS_DIBPATTERN8x8 */
    };

    static const Qt::PenStyle koWmfStylePen[] =
    { Qt::SolidLine, Qt::DashLine, Qt::DotLine, Qt::DashDotLine, Qt::DashDotDotLine,
      Qt::NoPen, Qt::SolidLine };

#endif

