/***************************************************************************
 * mainmodule.cpp
 * This file is part of the KDE project
 * copyright (C)2004-2005 by Sebastian Sauer (mail@dipe.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "mainmodule.h"

using namespace Kross::Api;

namespace Kross { namespace Api {

    /// \internal
    class MainModulePrivate
    {
        public:
           /**
            * The \a Exception this \a MainModule throwed or
            * NULL if we don't had an exception.
            */
            Exception::Ptr exception;
    };

}}

MainModule::MainModule(const TQString& name)
    : Module(name)
    , d(new MainModulePrivate())
{
    d->exception = 0;
}

MainModule::~MainModule()
{
    delete d;
}

const TQString MainModule::getClassName() const
{
    return "Kross::Api::MainModule";
}

bool MainModule::hadException()
{
    return d->exception != 0;
}

Exception::Ptr MainModule::getException()
{
    return d->exception;
}

void MainModule::setException(Exception::Ptr exception)
{
    d->exception = exception;
}

#if 0
bool MainModule::hasChild(const TQString& name) const
{
    return Callable::hasChild(name);
}
#endif

EventSignal::Ptr MainModule::addSignal(const TQString& name, TQObject* sender, TQCString signal)
{
    EventSignal* event = new EventSignal(name, sender, signal);
    if(! addChild(name, event)) {
        krosswarning( TQString("Failed to add signal name='%1' signature='%2'").arg(name).arg(signal.data()) );
        return 0;
    }
    return event;
}

EventSlot::Ptr MainModule::addSlot(const TQString& name, TQObject* receiver, TQCString slot)
{
    EventSlot* event = new EventSlot(name, receiver, slot);
    if(! addChild(name, event)) {
        krosswarning( TQString("Failed to add slot name='%1' signature='%2'").arg(name).arg(slot.data()) );
        return 0;
    }
    return event;
}

QtObject::Ptr MainModule::addTQObject(TQObject* object, const TQString& name)
{
    QtObject* qtobject = new QtObject(object, name);
    if(! addChild(name, qtobject)) {
        krosswarning( TQString("Failed to add TQObject name='%1'").arg(object->name()) );
        return 0;
    }
    return qtobject;
}

EventAction::Ptr MainModule::addKAction(KAction* action, const TQString& name)
{
    EventAction* event = new EventAction(name, action);
    if(! addChild(name, event)) {
        krosswarning( TQString("Failed to add KAction name='%1'").arg(action->name()) );
        return 0;
    }
    return event;
}

