/* This file is part of the KDE project
 * Copyright (c) 1999 Matthias Elter (me@kde.org)
 * Copyright (c) 2001-2002 Igor Jansen (rm@kde.org)
 * Copyright (c) 2005 Tim Beaulen (tbscope@gmail.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#ifndef KO_CMYK_WIDGET_H
#define KO_CMYK_WIDGET_H

#include "tqwidget.h"

#include <koffice_export.h>

class KoFrameButton;
class TQGridLayout;
class TQColor;
class KoColorSlider;
class TQLabel;
class TQSpinBox;
class KDualColorButton;

struct CMYKColor
{
    float C;
    float M;
    float Y;
    float K;
};

class KoCMYKWidget
     : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT
    typedef TQWidget super;

public:
    KoCMYKWidget(TQWidget *parent = 0L, const char *name = 0);
    virtual ~KoCMYKWidget() {}

public slots:
    /**
     * Set the current color to c. Do not emit the color changed signals
     */
    virtual void setFgColor(const TQColor & c);
    virtual void setBgColor(const TQColor & c);

signals:

    /**
     * Emitted when the current color is changed.
     */
    virtual void sigFgColorChanged(const TQColor & c);
    virtual void sigBgColorChanged(const TQColor & c);


protected slots:

    virtual void slotCChanged(int c);
    virtual void slotMChanged(int m);
    virtual void slotYChanged(int y);
    virtual void slotKChanged(int k);

    void slotFGColorSelected(const TQColor& c);
    void slotBGColorSelected(const TQColor& c);

private:

    void update(const TQColor fgColor, const TQColor);

    CMYKColor RgbToCmyk(const TQColor& col);
    TQColor CmykToRgb(const CMYKColor& c);

private:

    KoColorSlider *mCSlider;
    KoColorSlider *mMSlider;
    KoColorSlider *mYSlider;
    KoColorSlider *mKSlider;
    TQLabel *mCLabel;
    TQLabel *mMLabel;
    TQLabel *mYLabel;
    TQLabel *mKLabel;
    TQSpinBox *mCIn;
    TQSpinBox *mMIn;
    TQSpinBox *mYIn;
    TQSpinBox *mKIn;
    KDualColorButton *m_ColorButton;

    float m_fgC;
    float m_fgM;
    float m_fgY;
    float m_fgK;

    float m_bgC;
    float m_bgM;
    float m_bgY;
    float m_bgK;

    TQColor m_fgColor;
    TQColor m_bgColor;
};

#endif
