/* This file is part of the KDE project
   Copyright (C) 2001 Joseph Wenninger <jowenn@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef _SERIALLETTER_QtSql_POWER_PLUGIN_H_
#define _SERIALLETTER_QtSql_POWER_PLUGIN_H_

#include <tqdom.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kdialogbase.h>
#include <tqsqldatabase.h>
/* FOR THE DIRTY HACK */
#include <tqsqlcursor.h>
#include <tqsqldriver.h>
/* END FOR THE DIRTY HACK */
#include <tqguardedptr.h>

#include "defs.h"
#include "KWMailMergeDataSource.h"
#include "KWQtSqlSerialDataSourceBase.h"
#include "kwqtsqlpower.h"
#include "KWMySqlCursor.h"

/******************************************************************
 *
 * Class: KWQtSqlSerialDataSource
 *
 ******************************************************************/
class KWQtSqlPowerSerialDataSource: public KWQtSqlSerialDataSourceBase
{
    Q_OBJECT
//    TQ_OBJECT
    public:
    KWQtSqlPowerSerialDataSource(KInstance *inst,TQObject *parent);
    ~KWQtSqlPowerSerialDataSource();

    virtual void save( TQDomDocument &doc,TQDomElement&);
    virtual void load( TQDomElement& elem );
    virtual class TQString getValue( const class TQString &name, int record = -1 ) const;
    virtual int getNumRecords() const {
        return (myquery?((myquery->size()<0)?0:myquery->size()):0);
    }
    virtual  bool showConfigDialog(TQWidget *,int);
    virtual void refresh(bool force);

    protected:
	friend class KWQtSqlPowerMailMergeEditor;
	TQString query;
	KWMySqlCursor *myquery;

    void clearSampleRecord();
    void addSampleRecordEntry(TQString name);

};

/******************************************************************
 *
 * Class: KWQtSqlPowerMailMergeEditor
 *
 ******************************************************************/

class KWQtSqlPowerMailMergeEditor : public KDialogBase
{
    Q_OBJECT
//    TQ_OBJECT

public:
    KWQtSqlPowerMailMergeEditor( TQWidget *parent, KWQtSqlPowerSerialDataSource *db_ );
    ~KWQtSqlPowerMailMergeEditor();
private:
 KWQtSqlPowerSerialDataSource *db;
 KWQtSqlPowerWidget *widget;
private slots:
 void openSetup();
 void updateDBViews();
 void slotTableChanged ( TQListBoxItem * item );
 void slotExecute();
 void slotSetQuery();
};


#endif
