/* This file is part of the KDE project
   Copyright (C) 2002 Nash Hoogwater <nrhoogwater@wanadoo.nl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; using
   version 2 of the License.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef kwtablestylemanager_h
#define kwtablestylemanager_h

#include "KWFrameStyle.h"
#include "KWTableStyle.h"

#include <kdialogbase.h>
#include <tqgroupbox.h>
#include <tqptrlist.h>


class TQGridLayout;
class TQLineEdit;
class TQListBox;
class TQPushButton;
class TQWidget;
class TQFrame;
class TQComboBox;

class KWDocument;
class KoParagStyle;

class KoTextDocument;

/******************************************************************/
/* Class: KWTableStylePreview                                     */
/******************************************************************/

class KWTableStylePreview : public TQGroupBox
{
    Q_OBJECT
  TQ_OBJECT

public:
    KWTableStylePreview(const TQString &title, const TQString &text, TQWidget *parent, const char* name = 0);
    virtual ~KWTableStylePreview();

    void setTableStyle(KWTableStyle *_tableStyle);

protected:
    void drawContents( TQPainter *p );

    KWTableStyle *tableStyle;

    KoTextDocument *m_textdoc;
    KoTextZoomHandler *m_zoomHandler;
};

class KWTableStyleListItem
{
  public:
    KWTableStyleListItem() {}
    ~KWTableStyleListItem();
    KWTableStyleListItem(KWTableStyle *orig, KWTableStyle *changed) {
        m_origTableStyle = orig;
        m_changedTableStyle = changed;
    }

    KWTableStyle *origTableStyle()const { return m_origTableStyle; }
    KWTableStyle *changedTableStyle()const { return m_changedTableStyle; }
    void setOrigTableStyle( KWTableStyle *_orig ) { m_origTableStyle = _orig; }
    void setChangedTableStyle( KWTableStyle *_changed ) { m_changedTableStyle = _changed; }
    void deleteOrigTableStyle() { delete m_changedTableStyle; }
    void deleteChangedTableStyle() { delete m_changedTableStyle; }

    void switchStyle();
    void deleteStyle( KWTableStyle *current );
    void apply();

  protected:
    KWTableStyle *m_origTableStyle;
    KWTableStyle *m_changedTableStyle;
};

/******************************************************************/
/* Class: KWTableStyleManager                                     */
/******************************************************************/
class KWTableStyleManager : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT

public:
    KWTableStyleManager( TQWidget *_parent, KWDocument *_doc );
    ~KWTableStyleManager();

private:
    void setupWidget();
    void addGeneralTab();
    void apply();
    void updateGUI();
    void updatePreview();
    void save();
    int tableStyleIndex( int pos );

    void addStyles(const TQPtrList<KWTableStyle> &listStyle );

    TQListBox *m_stylesList;
    TQLineEdit *m_nameString;
    TQPushButton *m_deleteButton;
    TQPushButton *m_newButton;
    TQPushButton *m_moveUpButton;
    TQPushButton *m_moveDownButton;
    TQComboBox *m_frameStyle;
    TQComboBox *m_style;
    TQPushButton *m_changeFrameStyleButton;
    TQPushButton *m_changeStyleButton;
    TQStringList m_styleOrder;
    TQGroupBox *previewBox;
    KWTableStylePreview *preview;

    TQWidget *main;

    KWTableStyle *m_currentTableStyle;
    TQPtrList<KWTableStyleListItem> m_tableStyles;
    int numTableStyles;
    bool noSignals;

    KWDocument *m_doc;

protected slots:
    virtual void slotOk();
    virtual void slotApply();
    void updateAllStyleCombos();
    void changeFrameStyle();
    void changeStyle();
    void selectFrameStyle(int);
    void selectStyle(int);
    void switchStyle();
    void addStyle();
    void deleteStyle();
    void moveUpStyle();
    void moveDownStyle();
    void renameStyle(const TQString &);
    void setupMain();
    void importFromFile();
};

#endif
