/* This file is part of the KDE project
   Copyright (C)  2002 Montel Laurent <lmontel@mandrakesoft.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __KWCreateBookmarkDia__
#define __KWCreateBookmarkDia__

#include <kdialogbase.h>
#include <tqstringlist.h>
class TQLineEdit;
class TQListBox;
class KWDocument;
class TQPushButton;

class KWCreateBookmarkDia : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT
public:
    KWCreateBookmarkDia( const TQStringList & _list, TQWidget *parent, const char *name );
    KWCreateBookmarkDia( const TQStringList & _list, const TQString & _name, TQWidget *parent, const char *name );
    TQString bookmarkName()const;

protected slots:
    virtual void slotOk();
    void nameChanged( const TQString &text);

protected:
    void init();
    TQStringList listBookMark;
    TQLineEdit *m_bookmarkName;
};

class KWSelectBookmarkDia : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT
public:
    KWSelectBookmarkDia( const TQStringList & _list, KWDocument *_doc, TQWidget *parent, const char *name );
    TQString bookmarkSelected()const;
protected slots:
    void slotSelectionChanged();
    void slotRenameBookmark();
    void slotDeleteBookmark();
private:
    TQListBox *m_bookmarkList;
    KWDocument *m_doc;
    TQPushButton *m_pbDelete;
    TQPushButton *m_pbRename;
};

#endif
