// -*- Mode: c++; c-basic-offset: 4; indent-tabs-mode: nil; tab-width: 4; -*-
/* This file is part of the KDE project
   Copyright (C) 2002 Ariya Hidayat <ariya@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

// Slide Transition Effect dialog box

#ifndef __TRANSEFFECTDIA_H
#define __TRANSEFFECTDIA_H

#include <kdialogbase.h>
#include <tqlabel.h>
#include <tqtimer.h>
#include "global.h"

class KPrDocument;
class KPrView;
class TQCheckBox;
class TQSplitter;
class TQLabel;
class TQPushButton;
class TQCheckBox;
class TQSlider;
class TQString;
class TQComboBox;
class KPrBackGround;
class KPrObject;
class KPPresStructObjectItem;
class KURLRequester;
class KIntNumInput;
class KPrSoundPlayer;
class KPrPageEffects;

class KPrEffectPreview : public TQLabel
{
    Q_OBJECT
  TQ_OBJECT

public:
    KPrEffectPreview( TQWidget *parent, KPrDocument *_doc, KPrView *_view );

public slots:
    void setPixmap( const TQPixmap& pixmap );
    void run( PageEffect effect, EffectSpeed speed );

protected:
    KPrDocument *doc;
    KPrView *view;
    TQPixmap m_pixmap;
    TQPixmap m_target;

    TQTimer m_pageEffectTimer;
    KPrPageEffects *m_pageEffect;

protected slots:
    void slotDoPageEffect();
};


class KPrTransEffectDia: public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT

public:
    KPrTransEffectDia( TQWidget *parent, const char *name,
                      KPrDocument *_doc, KPrView *_view );

    PageEffect getPageEffect() const { return pageEffect; }
    EffectSpeed getPageEffectSpeed() const { return speed; }
    bool getSoundEffect() const { return soundEffect; }
    TQString getSoundFileName() const { return soundFileName; }
    bool getAutoAdvance() const { return false; } // FIXME !
    int getSlideTime() const { return slideTime; }

signals:
    void apply( bool global );

protected:
    virtual void slotOk();
    virtual void slotUser1();

    KPrDocument *doc;
    KPrView *view;

    PageEffect pageEffect;
    EffectSpeed speed;
    bool soundEffect;
    TQString soundFileName;

    KPrEffectPreview *effectPreview;

    TQListBox *effectList;
    TQComboBox *speedCombo;

    TQCheckBox *automaticPreview;
    TQPushButton *previewButton;

    TQCheckBox *checkSoundEffect;
    TQLabel *lSoundEffect;
    KURLRequester *requester;
    TQPushButton *buttonTestPlaySoundEffect, *buttonTestStopSoundEffect;

    KIntNumInput* timeSlider;
    int slideTime;

    KPrSoundPlayer *soundPlayer;

protected slots:

    void preview();
    void effectChanged( int );
    void effectChanged();

    void speedChanged( int );
    void timeChanged( int );

    void soundEffectChanged();
    void slotRequesterClicked( KURLRequester * );
    void slotSoundFileChanged( const TQString& );
    void playSound();
    void stopSound();
};

#endif // __TRANSEFFECTDIA_H
