/* This file is part of the KDE project
   Copyright (C) 2001,2002,2003,2004 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __KCHARTPARAMETERCONFIGPAGE_H__
#define __KCHARTPARAMETERCONFIGPAGE_H__

#include <tqwidget.h>
#include <kcolorbutton.h>

class TQSpinBox;
class TQCheckBox;
class TQLineEdit;
class TQRadioButton;

namespace KChart
{

class KChartParams;

class KChartParameterConfigPage : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT

public:
    KChartParameterConfigPage( KChartParams* params, TQWidget* parent );
    void init();
    void apply();
public slots:
    void changeXaxisState( bool );
    void automatic_precision_toggled( bool );
    void axisChanged();
private:
    KChartParams* _params;

    // Checkboxes on the left side of the tab.
    TQCheckBox *grid;
    TQCheckBox *xaxis;
    TQCheckBox *yaxis;
    //TQCheckBox *yaxis2;
    //TQCheckBox *xlabel;
    TQCheckBox *lineMarker;
    //TQCheckBox *llabel;

    // Lineedits on the right side of the tab.
    TQLineEdit *xtitle;
    TQLineEdit *ytitle;

    TQRadioButton *lin;
    TQRadioButton *log;

    TQRadioButton *max;
    TQSpinBox *maximum_length;
    //TQLineEdit *ylabel_fmt;
    //TQLineEdit *ytitle2;
    //TQLineEdit *ylabel2_fmt;
    //TQLineEdit *annotation;
};

}  //KChart namespace

#endif
