/* This file is part of the KDE project
   Copyright (C) 2001,2002,2003,2004 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __KCHARTDATACONFIGPAGE_H__
#define __KCHARTDATACONFIGPAGE_H__

#include <tqwidget.h>
#include <tqbutton.h>
#include <tqlistbox.h>
#include <tqpainter.h>

#include "koChart.h"


class TQLineEdit;
class TQRadioButton;
class TQCheckBox;


namespace KChart
{

class  KChartParams;

class KChartDataConfigPage : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT

public:
    KChartDataConfigPage( KChartParams* params, TQWidget* parent,
			  KDChartTableData *dat);
    void init();
    void defaults();
    void apply();

public slots:

private:
    KChartParams      *m_params;
    KDChartTableData  *data;

    TQLineEdit    *m_dataArea;
    TQRadioButton *m_rowMajor;
    TQRadioButton *m_colMajor;
    TQCheckBox    *m_firstRowAsLabel;
    TQCheckBox    *m_firstColAsLabel;
};

}  //KChart namespace

#endif
