/*
    Copyright (C) 2000, S.R.Haque <shaheedhaque@hotmail.com>.
    This file is part of the KDE project

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

DESCRIPTION

    This is a generic parser for Microsoft Powerpoint documents. The output is
    a series of callbacks (a.k.a. virtual functions) which the caller can
    override as required.
*/

#ifndef POWERPOINT_H
#define POWERPOINT_H


#include <myfile.h>
#include <tqdatastream.h>
#include <tqptrlist.h>
#include <tqmap.h>
#include <pptSlide.h>

typedef TQ_INT32 sint4; // signed 4-byte integral value
typedef TQ_INT16 sint2; // signed 4-byte integral value
typedef TQ_UINT32 uint4; // unsigned 4-byte integral value
typedef TQ_UINT16 uint2; // 2-byte
typedef TQ_INT8 bool1; // 1-byte boolean
typedef TQ_UINT8 ubyte1; // unsigned byte value
typedef uint2 psrType;
typedef uint4 psrSize; // each record is preceded by
// pssTypeType and pssSizeType.
typedef uint2 psrInstance;
typedef uint2 psrVersion;
typedef uint4 psrReference; // Saved object reference
//typedef TQList<PptSlide> PptSlideList;

class Powerpoint
{
public:

    // Construction.

    Powerpoint();
    virtual ~Powerpoint();

    // Called to parse the given file.

    bool parse(
        myFile &mainStream,
        myFile &currentUser,
        myFile &pictures);

    typedef struct
    {
        unsigned type;
        TQString data;
    } SlideText;

    typedef struct
    {
        unsigned persistentReference;
        TQPtrList<SlideText> text;
    } Slide;

protected:

    virtual void gotDrawing(
        unsigned id,
        TQString type,
        unsigned length,
        const char *data) = 0;
    virtual void gotSlide(
         PptSlide &slide) = 0;

private:
    Powerpoint(const Powerpoint &);
    const Powerpoint &operator=(const Powerpoint &);

    // Debug support.

public:
    static const int s_area;

private:
    myFile m_mainStream;
    myFile m_pictures;
    unsigned m_documentRef;
    bool m_documentRefFound;
    TQMap<unsigned, unsigned> m_persistentReferences;
    unsigned 	m_editDepth;
    enum
    {
        PASS_GET_SLIDE_REFERENCES,
        PASS_GET_SLIDE_CONTENTS
    } m_pass;
    unsigned m_textType;
    
    TQPtrList<PptSlide>	m_slideList;
    PptSlide*		m_pptSlide;

struct PSR_CurrentUserAtom
{
	uint4 size;
	uint4 magic; // Magic number to ensure this is a PowerPoint file.
	uint4 offsetToCurrentEdit; // Offset in main stream to current edit field.
	uint2 lenUserName;
	uint2 docFileVersion;
	ubyte1 majorVersion;
	ubyte1 minorVersion;
};

struct PSR_UserEditAtom
{
	sint4 lastSlideID; // slideID
	uint4 version; // This is major/minor/build which did the edit
	uint4 offsetLastEdit; // File offset of last edit
	uint4 offsetPersistDirectory; // Offset to PersistPtrs for
	// this file version.
	uint4 documentRef;
	uint4 maxPersistWritten; // Addr of last persist ref written to the file (max seen so far).
	sint2 lastViewType; // enum view type
};

struct PSR_SSlideLayoutAtom
{
	sint4 geom;
	ubyte1 placeholderId[8];
};

    PSR_CurrentUserAtom mCurrentUserAtom;
    PSR_UserEditAtom    mUserEditAtom;
    PSR_UserEditAtom*   mpLastUserEditAtom;
    TQ_UINT32            mEditOffset;

    // Common Header.

    typedef struct
    {
        union
        {
            TQ_UINT16 info;
            struct
            {
                TQ_UINT16 version: 4;
                TQ_UINT16 instance: 12;
            } fields;
        } opcode;
        TQ_UINT16 type;
        TQ_UINT32 length;
    } Header;

    // Opcode handling and painter methods.

    void walk(
        TQ_UINT32 bytes,
        TQDataStream &operands);
    void walk(
        TQ_UINT32 mainStreamOffset);
    void walkRecord(
        TQ_UINT32 bytes,
        const unsigned char *operands);
    void walkRecord(
        TQ_UINT32 mainStreamOffset);
    void walkReference(
        TQ_UINT32 reference);
    void skip(
        TQ_UINT32 bytes,
        TQDataStream &operands);
    void invokeHandler(
        Header &op,
        TQ_UINT32 bytes,
        TQDataStream &operands);
    void walkDocument();

    void opAnimationInfo(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opAnimationInfoAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opArrayElementAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opBaseTextPropAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opBinaryTagData(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opBookmarkCollection(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opBookmarkEntityAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opBookmarkSeedAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opCharFormatAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opClientSignal1(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opClientSignal2(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opColorSchemeAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opCorePict(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opCorePictAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opCString(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opCurrentUserAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opDateTimeMCAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opDefaultRulerAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opDocRoutingSlip(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opDocument(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opDocumentAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opDocViewInfo(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opEmFormatAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opEndDocument(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opEnvironment(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExAviMovie(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExCDAudio(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExCDAudioAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExControl(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExControlAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExEmbed(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExEmbedAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExHyperlink(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExHyperlinkAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExLink(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExLinkAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExLinkAtom_old(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExMCIMovie(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExMediaAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExMIDIAudio(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExObjList(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExObjListAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExObjRefAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExOleObj(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExOleObjAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExOleObjStg(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExPlain(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExPlainAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExPlainLink(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExPlainLinkAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExQuickTime(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExQuickTimeMovie(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExQuickTimeMovieData(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExSubscription(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExSubscriptionSection(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExternalObject(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExVideo(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExWAVAudioEmbedded(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExWAVAudioEmbeddedAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opExWAVAudioLink(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opFontCollection(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opFontEmbedData(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opFontEntityAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opFooterMCAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opGenericDateMCAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opGlineAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opGLPointAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opGpointAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opGratioAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opGrColor(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opGrColorAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opGrectAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opGscaling(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opGscalingAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opGuideAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opGuideList(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opHandout(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opHeaderMCAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opHeadersFooters(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opHeadersFootersAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opInt4ArrayAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opInteractiveInfo(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opInteractiveInfoAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opIRRAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opList(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opListPlaceholder(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opMainMaster(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opMasterText(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opMetaFile(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opMsod(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opNamedShow(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opNamedShows(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opNamedShowSlides(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opNotes(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opNotesAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opOEPlaceholderAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opOEShape(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opOEShapeAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opOutlineTextRefAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opOutlineViewInfo(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opParaFormatAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opPersistPtrFullBlock(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opPersistPtrIncrementalBlock(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opPersistPtrIncrementalBlock2(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opPowerPointStateInfoAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opPPDrawing(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opPPDrawingGroup(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opPrintOptions(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opProgBinaryTag(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opProgStringTag(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opProgTags(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opPSS(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opRecolorEntryAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opRecolorInfoAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opRTFDateTimeMCAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opRulerIndentAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opRunArray(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opRunArrayAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opScheme(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSchemeAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSlide(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSlideAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSlideBase(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSlideBaseAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSlideList(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSlideListWithText(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSlideNumberMCAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSlidePersist(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSlidePersistAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSlideViewInfo(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSlideViewInfoAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSorterViewInfo(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSound(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSoundCollAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSoundCollection(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSoundData(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSrKinsoku(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSrKinsokuAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSSDocInfoAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSSSlideLayoutAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSSSlideInfoAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opStyleTextPropAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSubContainerCompleted(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSubContainerException(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opSummary(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opTextBookmarkAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opTextBytesAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opTextCharsAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opTextHeaderAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opTextRulerAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opTextSpecInfoAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opTexture(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opTxCFStyleAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opTxInteractiveInfoAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opTxMasterStyleAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opTxPFStyleAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opTxSIStyleAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opTypeFace(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opUserEditAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opVBAInfo(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opVBAInfoAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opVBASlideInfo(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opVBASlideInfoAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opViewInfo(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
    void opViewInfoAtom(Header &op, TQ_UINT32 bytes, TQDataStream &operands);
};
#endif
