/* This file is part of the KDE project
   Copyright (C) 2000 Enno Bartels <ebartels@nwn.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef APPLIXWORDIMPORT_H
#define APPLIXWORDIMPORT_H

#include <tqstring.h>
#include <tqstringlist.h>
#include <tqfile.h>
#include <tqobject.h>
#include <tqtextstream.h>

#include <KoFilter.h>
#include <KoStore.h>

typedef struct
{
  int c;
  int m;
  int y;
  int k;

  int r;
  int g;
  int b;
}t_mycolor;

class APPLIXWORDImport : public KoFilter {

    Q_OBJECT
  TQ_OBJECT

public:
    APPLIXWORDImport(KoFilter *parent, const char *name, const TQStringList&);
    virtual ~APPLIXWORDImport() {}

    virtual KoFilter::ConversionStatus convert( const TQCString& from, const TQCString& to );

protected:
    TQChar   specCharfind     (TQChar , TQChar );
    TQString readTagLine      (TQTextStream &, TQFile &);
    void    replaceSpecial   (TQString &);
    TQString nextLine         (TQTextStream &);
    int     readHeader       (TQTextStream &stream, TQFile &);

private:
    int m_stepsize;
    int m_instep;
    int m_progress;

};
#endif // APPLIXWORDIMPORT_H
