/***************************************************************************
 *   Copyright (C) 2005 Eyal Lotem <eyal.lotem@gmail.com>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/
#ifndef PIXMAPVIEWER_H
#define PIXMAPVIEWER_H

#include <tqscrollview.h>
#include <tqimage.h>

class TQLabel;

/**
 * A scrollable image view.
 *
 * XXX: We should add a signal that emits newly eposed rects so the filters
 *      don't have to filter everything, but just the the new bits.
 */
class ImageViewer : public TQScrollView {
    Q_OBJECT
  TQ_OBJECT

public:
    ImageViewer(TQWidget *widget, const char * name = 0);

    void setImage(TQImage & image);
    
    void contentsMousePressEvent(TQMouseEvent *event);
    void contentsMouseReleaseEvent(TQMouseEvent *event);
    void contentsMouseMoveEvent(TQMouseEvent *event);
    void wheelEvent(TQWheelEvent * event) { event->ignore(); };
private:
    TQLabel* m_label;
    bool m_isDragging;
    TQPoint m_currentPos;
    TQPixmap m_image;
};

#endif
