/*
 * This file is part of Chalk
 *
 * Copyright (c) 2005 Cyrille Berger <cberger@cberger.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "filters_gallery.h"

#include <tqapplication.h>

#include <kdebug.h>
#include <kgenericfactory.h>
#include <kstandarddirs.h>

#include <kopalettemanager.h>

#include <kis_colorspace_factory_registry.h>
#include "kis_progress_display_interface.h"
#include <kis_dlg_filtersgallery.h>
#include <kis_doc.h>
#include <kis_filter.h>
#include <kis_filters_listview.h>
#include <kis_meta_registry.h>
#include <kis_paint_device.h>
#include <kis_selection.h>
#include <kis_view.h>
#include <kis_transaction.h>

namespace Chalk {
namespace Plugins {
namespace FiltersGallery {

typedef KGenericFactory<ChalkFiltersGallery> ChalkFiltersGalleryFactory;
K_EXPORT_COMPONENT_FACTORY( chalkfiltersgallery, ChalkFiltersGalleryFactory( "chalk" ) )

ChalkFiltersGallery::ChalkFiltersGallery(TQObject *parent, const char *name, const TQStringList &)
        : KParts::Plugin(parent, name)
{

    if ( parent->inherits("KisView") )
    {
        setInstance(ChalkFiltersGallery::instance());
        setXMLFile(locate("data","chalkplugins/chalkfiltersgallery.rc"), true);

        m_view = (KisView*) parent;

        (void) new KAction(i18n("&Filters Gallery"), 0, 0, this, TQT_SLOT(showFiltersGalleryDialog()), actionCollection(), "chalk_filters_gallery");

        // Add a docker with the list of filters
//         TQImage img;
//         if(img.load(locate("data","chalk/images/previewfilter.png")))
//         {
//            KisPaintDeviceSP preview = new KisPaintDevice(KisMetaRegistry::instance()->csRegistry()->getColorSpace(KisID("RGBA",""),""));
//            preview->convertFromTQImage(img,"");
//            m_view->canvasSubject()->paletteManager()->addWidget(new KisFiltersListView(preview,m_view),"filterslist",chalk::EFFECTSBOX, 0);
//         }

    }


}

ChalkFiltersGallery::~ChalkFiltersGallery()
{
}

void ChalkFiltersGallery::showFiltersGalleryDialog()
{
    KisDlgFiltersGallery dlg(m_view, m_view);
    if (dlg.exec())
    {
        TQApplication::setOverrideCursor( TQt::waitCursor );

        KisFilter* filter = dlg.currentFilter();
        if(filter )
        {
            KisImageSP img = m_view->canvasSubject()->currentImg();
            if (!img) return;

            KisPaintDeviceSP dev = img->activeDevice();
            if (!dev) return;
            TQRect r1 = dev->exactBounds();
            TQRect r2 = img->bounds();

            TQRect rect = r1.intersect(r2);

            if (dev->hasSelection()) {
                TQRect r3 = dev->selection()->selectedExactRect();
                rect = rect.intersect(r3);
            }
            KisFilterConfiguration* config = filter->configuration( dlg.currentConfigWidget());

            filter->enableProgress();
            m_view->canvasSubject()->progressDisplay()->setSubject(filter, true, true);
            filter->setProgressDisplay(m_view->canvasSubject()->progressDisplay());

            KisTransaction * cmd = new KisTransaction(filter->id().name(), dev);

            filter->process(dev,dev, config, rect);

            delete config;
            if (filter->cancelRequested()) {
                cmd->unexecute();
                delete cmd;
            } else {
                dev->setDirty(rect);
                if (img->undo())
                    img->undoAdapter()->addCommand(cmd);
                else
                    delete cmd;
            }
            filter->disableProgress();
            TQApplication::restoreOverrideCursor();

        }
    }
}

}
}
}

#include "filters_gallery.moc"
