/*
 *  kis_tool_crop.h - part of Chalk
 *
 *  Copyright (c) 2004 Boudewijn Rempt <boud@valdyas.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef KIS_TOOL_CROP_H_
#define KIS_TOOL_CROP_H_

#include <tqpoint.h>
#include <tqregion.h>
#include <kis_tool_non_paint.h>
#include <kis_tool_factory.h>

class TQRect;
class TQCursor;
class WdgToolCrop;

/**
 * Crop tool
 *
 * TODO: - crop from selection -- i.e, set crop outline to the exact bounds of the selection.
 *       - (when moving to TQt 4: replace rectangle with  darker, dimmer overlay layer
 *         like we have for selections right now)
 */
class KisToolCrop : public KisToolNonPaint {

    typedef KisToolNonPaint super;
    Q_OBJECT
  TQ_OBJECT

public:

    KisToolCrop();
    virtual ~KisToolCrop();

    virtual void update(KisCanvasSubject *subject);

    virtual TQWidget* createOptionWidget(TQWidget* parent);
    virtual TQWidget* optionWidget();

    virtual void setup(KActionCollection *collection);
    virtual enumToolType toolType() { return TOOL_TRANSFORM; }
    virtual TQ_UINT32 priority() { return 1; }
    virtual void paint(KisCanvasPainter& gc);
    virtual void paint(KisCanvasPainter& gc, const TQRect& rc);
    virtual void buttonPress(KisButtonPressEvent *e);
    virtual void move(KisMoveEvent *e);
    virtual void buttonRelease(KisButtonReleaseEvent *e);
    virtual void doubleClick(KisDoubleClickEvent *);

public slots:

    virtual void activate();
    virtual void deactivate();

private:

    void clearRect();
    TQRegion handles(TQRect rect);
    void paintOutlineWithHandles();
    void paintOutlineWithHandles(KisCanvasPainter& gc, const TQRect& rc);
    TQ_INT32 mouseOnHandle (const TQPoint currentViewPoint);
    void setMoveResizeCursor (TQ_INT32 handle);
    void validateSelection(bool updateratio = true);
    void setOptionWidgetX(TQ_INT32 x);
    void setOptionWidgetY(TQ_INT32 y);
    void setOptionWidgetWidth(TQ_INT32 x);
    void setOptionWidgetHeight(TQ_INT32 y);
    void setOptionWidgetRatio(double ratio);

private slots:

    void crop();
    void setCropX(int x);
    void setCropY(int y);
    void setCropWidth(int x);
    void setCropHeight(int y);
    void setRatio(double ratio);

    inline TQRect realRectCrop() { TQRect r = m_rectCrop; r.setSize(r.size() - TQSize(1,1)); return r; }
    
private:
    void updateWidgetValues(bool updateratio = true);
    KisCanvasSubject *m_subject;
    TQRect m_rectCrop; // Is the coordinate of the outline rect and not of the region to crop (to get the region to crop you need to remove 1 to width and height
//     TQPoint m_startPos;
//     TQPoint m_endPos;
    bool m_selecting;
    TQPoint m_dragStart;
    TQPoint m_dragStop;

    WdgToolCrop* m_optWidget;

    TQ_INT32 m_handleSize;
    TQRegion m_handlesRegion;
    bool m_haveCropSelection;
    TQ_INT32 m_dx, m_dy;
    TQ_INT32 m_mouseOnHandleType;
    TQCursor m_cropCursor;

    enum handleType
    {
        None = 0,
        UpperLeft = 1,
        UpperRight = 2,
        LowerLeft = 3,
        LowerRight = 4,
        Upper = 5,
        Lower = 6,
        Left = 7,
        Right = 8,
        Inside = 9
    };
};

class KisToolCropFactory : public KisToolFactory {
    typedef KisToolFactory super;
public:
    KisToolCropFactory() : super() {};
    virtual ~KisToolCropFactory(){};

    virtual KisTool * createTool(KActionCollection * ac) {
        KisTool * t = new KisToolCrop();
        Q_CHECK_PTR(t);
        t->setup(ac);
        return t;
    }
    virtual KisID id() { return KisID("crop", i18n("Crop Tool")); }
};



#endif // KIS_TOOL_CROP_H_

