/***************************************************************************
 *
 * knetworkmanager-pptp.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <klocale.h>
#include <tqmessagebox.h>
#include <tqbutton.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <kurlrequester.h>
#include <tqobjectlist.h>
#include <tqobject.h>
#include <tqcheckbox.h>
#include <kpassdlg.h>
#include <kgenericfactory.h>
#include <tqlabel.h>

#include "knetworkmanager-pptp.h"

typedef KGenericFactory<PPTPPlugin> PPTPPluginFactory;
K_EXPORT_COMPONENT_FACTORY( knetworkmanager_pptp, PPTPPluginFactory("knetworkmanager_pptp"));


PPTPPlugin::PPTPPlugin(TQObject* parent, const char* name, const TQStringList& args)
	: VPNPlugin(parent, name, args)
{
	KLocale* loc = KGlobal::locale();
	loc->insertCatalogue("NetworkManager-pptp");
}

PPTPPlugin::~PPTPPlugin()
{

}

VPNConfigWidget* PPTPPlugin::CreateConfigWidget(TQWidget* parent)
{
	return new PPTPConfig(parent);
}

VPNAuthenticationWidget* PPTPPlugin::CreateAuthenticationWidget(TQWidget* parent)
{
	return new PPTPAuthentication(parent);
}


PPTPConfig::PPTPConfig(TQWidget* parent)
	: VPNConfigWidget(parent)
{
	TQVBoxLayout* layout = new TQVBoxLayout(this, 1, 1);
	_pptpWidget = new PPTPConfigWidget(this);
	layout->addWidget(_pptpWidget);

	connect(_pptpWidget->chkIPAdresses, TQT_SIGNAL(toggled(bool)), _pptpWidget->routes, TQT_SLOT(setEnabled(bool)));

	this->languageChange();
}

PPTPConfig::~PPTPConfig()
{

}

void PPTPConfig::languageChange()
{

}

void PPTPConfig::setVPNData(const TQStringList& routes, const TQMap<TQString, TQString>& properties)
{
	// fill up our inputfields (only textfields atm)
	for(TQMap<TQString, TQString>::ConstIterator it = properties.begin(); it != properties.end(); ++it)
	{
		TQString entry = it.key();
		TQString value = it.data();

		if (entry == "gateway")
		{
			_pptpWidget->gateway->setText(value);
		}
		else if (entry == "refuse-eap")
		{
			_pptpWidget->chk_refuseeap->setChecked(value == "yes" || value == "true");
		}
		else if (entry == "refuse-pap")
		{
			_pptpWidget->chk_refusepap->setChecked(value == "yes" || value == "true");
		}
		else if (entry == "refuse-chap")
		{
			_pptpWidget->chk_refusechap->setChecked(value == "yes" || value == "true");
		}
		else if (entry == "refuse-mschap")
		{
			_pptpWidget->chk_refusemschap->setChecked(value == "yes" || value == "true");
		}
		else if (entry == "refuse-mschapv2")
		{
			_pptpWidget->chk_refusemschapv2->setChecked(value == "yes" || value == "true");
		}
		else if (entry == "require-mppe")
		{
			_pptpWidget->chk_requiremppe->setChecked(value == "yes" || value == "true");
		}
		else if (entry == "require-mppe-40")
		{
			_pptpWidget->chk_requiremppe40->setChecked(value == "yes" || value == "true");
		}
		else if (entry == "require-mppe-128")
		{
			_pptpWidget->chk_requiremppe128->setChecked(value == "yes" || value == "true");
		}
		else if (entry == "mppe-stateful")
		{
			_pptpWidget->chk_mppestateful->setChecked(value == "yes" || value == "true");
		}
		else if (entry == "nodeflate")
		{
			_pptpWidget->chk_nodeflate->setChecked(value == "yes" || value == "true");
		}
	}

	// set routes
	if (!routes.empty())
	{
		_pptpWidget->chkIPAdresses->setChecked(true);
		_pptpWidget->routes->setText(routes.join(" "));
	}
}

TQMap<TQString, TQString> PPTPConfig::getVPNProperties()
{
	// build a StingList of properties
	TQMap<TQString, TQString> strlist;
	strlist.insert("gateway", TQString(_pptpWidget->gateway->text()));
	strlist.insert("refuse-eap", TQString(_pptpWidget->chk_refuseeap->isChecked() ? "yes" : "no"));
	strlist.insert("refuse-pap", TQString(_pptpWidget->chk_refusepap->isChecked() ? "yes" : "no"));
	strlist.insert("refuse-chap", TQString(_pptpWidget->chk_refusechap->isChecked() ? "yes" : "no"));
	strlist.insert("refuse-mschap", TQString(_pptpWidget->chk_refusemschap->isChecked() ? "yes" : "no"));
	strlist.insert("refuse-mschapv2", TQString(_pptpWidget->chk_refusemschapv2->isChecked() ? "yes" : "no"));
	strlist.insert("require-mppe", TQString(_pptpWidget->chk_requiremppe->isChecked() ? "yes" : "no"));
	strlist.insert("require-mppe-40", TQString(_pptpWidget->chk_requiremppe40->isChecked() ? "yes" : "no"));
	strlist.insert("require-mppe-128", TQString(_pptpWidget->chk_requiremppe128->isChecked() ? "yes" : "no"));
	strlist.insert("mppe-stateful", TQString(_pptpWidget->chk_mppestateful->isChecked() ? "yes" : "no"));
	strlist.insert("nodeflate", TQString(_pptpWidget->chk_nodeflate->isChecked() ? "yes" : "no"));

	// Current network-manager-pptp plugin supports bluetooth-gprs,dialup and pptp.
	// We want a pptp connection.
	//strlist.insert("ppp-connection-type", "pptp");

	return strlist;
}

TQStringList PPTPConfig::getVPNRoutes()
{
	TQStringList strlist;
	if(_pptpWidget->chkIPAdresses->isChecked())
	{
		strlist = TQStringList::split(" ", _pptpWidget->routes->text());
	}
	return strlist;

}

bool PPTPConfig::hasChanged()
{
	return true;
}

bool PPTPConfig::isValid(TQStringList& err_msg)
{
	bool retval = true;
	if(_pptpWidget->gateway->text() == "")
	{
		err_msg.append(i18n("At least the gateway has to be supplied."));
		retval = false;
	}
	return retval;
}

PPTPAuthentication::PPTPAuthentication(TQWidget* parent, char* name)
	: VPNAuthenticationWidget(parent, name)
{
	TQVBoxLayout* layout = new TQVBoxLayout(this, 1, 1);
	_pptpAuth = new PPTPAuthenticationWidget(this);
	layout->addWidget(_pptpAuth);
}

PPTPAuthentication::~PPTPAuthentication()
{

}

TQMap<TQString, TQString> PPTPAuthentication::getPasswords()
{
	// network-manager-pptp will fail hard if "CHAP" is not the
	// first element in the username&password list.
	TQMap<TQString, TQString> pwds;
	//pwds.insert("CHAP", "CHAP");
	pwds.insert("user", TQString(_pptpAuth->username->text()));
	pwds.insert("password", TQString(_pptpAuth->password->password()));
	pwds.insert("domain", TQString(_pptpAuth->domain->text()));
	return pwds;
}

void PPTPAuthentication::setPasswords(TQString name, TQString value) {
	if (name == TQString("password")) {
		_pptpAuth->password->erase();
		_pptpAuth->password->insert(value);
	}
}