/***************************************************************************
 *
 * secret_storage_plugin.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_SECRET_STORAGE_PLUGIN_H
#define KNETWORKMANAGER_SECRET_STORAGE_PLUGIN_H

#include <tqwidget.h>
#include <tqmap.h>
#include <tqdbusdata.h>
#include <tqdbusvariant.h>
#include "knetworkmanager-plugin.h"

#define KNETWORKMANAGER_SECRET_STORAGE_PLUGIN "KNetworkManager/SecretStoragePlugin"

class SecretStoragePlugin : public Plugin
{
	Q_OBJECT
  TQ_OBJECT
	public:
		SecretStoragePlugin(TQObject*, const char*, const TQStringList&);
		virtual ~SecretStoragePlugin();

		virtual bool saveSecret(TQString& key, TQMap<TQString, TQString>& secrets);
		virtual void restoreSecretsAsync(TQString& key);

	signals:
		void signalSecretsRestored(TQString& key, TQMap<TQString, TQString>, bool);
};


#endif /* KNETWORKMANAGER_SECRET_STORAGE_PLUGIN_H */

