/***************************************************************************
 *
 * knetworkmanager.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author:  Helmut Schaa    <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_WIRELESSMENUITEM_H
#define KNETWORKMANAGER_WIRELESSMENUITEM_H

#include "knetworkmanager-menuitem.h"

#include <tqmap.h>
#include <tqtimer.h>

#include <tqtooltip.h>
#include <ksystemtray.h>
#include <kuniqueapplication.h>
#include <kpopupmenu.h>
#include <kactionclasses.h>
#include <kstdaction.h>
#include <kstdguiitem.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqcheckbox.h>
#include <tqprogressbar.h>
#include <tqguardedptr.h>

#include "knetworkmanager-wireless_network.h"
#include "knetworkmanager-connection.h"

class WirelessNetworkItem : public NetworkMenuItem, public TQCustomMenuItem
{
	Q_OBJECT
  TQ_OBJECT
	public:
	  WirelessNetworkItem  (TQWidget*, Device* dev, WirelessNetwork& net, ConnectionSettings::WirelessConnection* conn, bool adhoc);
	  WirelessNetworkItem  (TQWidget*, Device* dev, WirelessNetwork& net, bool adhoc);
	  ~WirelessNetworkItem ();

	  TQWidget*      parent;
	  TQProgressBar* pbarStrength;

	  void  paint    (TQPainter*, const TQColorGroup&, bool, bool, int, int, int, int);
	  TQSize sizeHint ();

	public slots:
		void slotActivate();

	private:
		TQString getDisplayText();

	  bool    _adhoc;
		WirelessNetwork _net;
		Device* _dev;
		ConnectionSettings::WirelessConnection* _conn;

	  /* menu item */
	  int _width;
	  int _height;
	  int _border;

	  /* elements */
	  int _textHeight;
	  int _widgetHeight;

	  int _space;
};

#endif /* KNETWORKMANAGER_WIRELESSMENUITEM_H */
