/***************************************************************************
 *
 * knetworkmanager-vpnauthenticationdialog.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <stdlib.h>
#include <kpushbutton.h>
#include <tqbuttongroup.h>
#include <tqcombobox.h>
#include <tqmessagebox.h>
#include <tqwidgetstack.h>
#include <klineedit.h>
#include <tqlabel.h>
#include <klocale.h>
#include <kdebug.h>
#include <tqobjectlist.h>
#include <tqcheckbox.h>
#include <tqfocusdata.h>
#include <kiconloader.h>
#include <tqmap.h>

#include <tqdbusobjectpath.h>
#include <tqdbuserror.h>

#include "knetworkmanager-vpnservice.h"
#include "knetworkmanager-vpnmanager.h"
#include "knetworkmanager-vpnauthenticationdialog.h"
#include "knetworkmanager-vpn_connection.h"
#include "knetworkmanager-nm_proxy.h"
#include "knetworkmanager-connection_setting_vpn.h"
#include "knetworkmanager-connection_setting_info.h"

extern TQT_DBusObjectPath vpn_attempt_this_conn;

using namespace ConnectionSettings;


/*
 * class VPNAuthenticationDialog
 *
 */
VPNAuthenticationDialog::VPNAuthenticationDialog(VPNConnection* conn, TQWidget* parent, const char* name, bool modal, WFlags fl)
	: AuthenticationDialog(parent, name, modal, fl)
	, _conn(conn)
{
	this->setIcon(SmallIcon("encrypted", TQIconSet::Automatic));
	this->setCaption(i18n("VPN Authentication for %1").arg(conn->getInfoSetting()->getName()));
	labelPixmap->setPixmap(KGlobal::instance()->iconLoader()->loadIcon("encrypted", KIcon::Small, 32));

	// nice icons
	pushOK->setIconSet(SmallIcon("button_ok", TQIconSet::Automatic));
	pushCancel->setIconSet(SmallIcon("button_cancel", TQIconSet::Automatic));

	// we need the last widget in the focus queue
	TQFocusData* foc = focusData();
	TQWidget* lastFocusWidget = foc->last();

	VPN* vpn = conn->getVPNSetting();
	VPNService* vpnservice = VPNManager::getVPNService(vpn->getServiceType());
	
	// get the appropriate plugin and create the authentication widget
	VPNPlugin* vpnPlugin = vpnservice->getVPNPlugin();
	if (vpnPlugin)
	{
		_vpnAuthWidget = vpnPlugin->CreateAuthenticationWidget(widgetStack);
		if (_vpnAuthWidget)
		{
			_vpnAuthWidget->setVPNData(conn->getVPNSetting()->getRoutes(), conn->getVPNSetting()->getData());
			widgetStack->raiseWidget(_vpnAuthWidget);
		}
	}
	
	/*
	 the widgets inside the authenticationwidget are now in the focus queue
	 ==> we can now search the first widget inside the authenticationwidget 
	     which has to get the focus
	*/
	TQWidget* widget = foc->home();
	for (int i = 0; i < foc->count(); ++i)
	{
		if (widget == lastFocusWidget)
		{
			// the next one is the first widget inside the authwidget
			widget = foc->next();
			break;
		}
		widget = foc->next();
	}
	if (widget)
		widget->setFocus();

	// resize
	this->resize(minimumSizeHint());
}

VPNAuthenticationDialog::~VPNAuthenticationDialog()
{
	
}

bool VPNAuthenticationDialog::close(bool alsoDelete)
{
	// no secrets provided, tell NM
	_conn->slotSecretsError();
	return AuthenticationDialog::close(alsoDelete);
}

void VPNAuthenticationDialog::ok()
{
	// Good, we have new secrets now, update the settings
	TQMap<TQString, TQString> mypwds;

	mypwds = _vpnAuthWidget->getPasswords();
	ConnectionSetting* propcore = _conn->getVPNSettingConnectionCore();
	SettingsMap othersettingsmap = propcore->toMap();

	// Pull the username and gateway out of mypwds to stuff in the NM standard settings matrix
	othersettingsmap.insert("user", TQT_DBusData::fromString(mypwds["user"]));
	mypwds.erase("user");
	othersettingsmap.insert("domain", TQT_DBusData::fromString(mypwds["domain"]));
	mypwds.erase("domain");
// 	othersettingsmap.erase("Commit to disk");
// 	if (chkStorePasswordsPermanent->isChecked() == true) {
// 		othersettingsmap.insert("Commit to disk", TQT_DBusData::fromString("true"));
// 	}
// 	else {
// 		othersettingsmap.insert("Commit to disk", TQT_DBusData::fromString("false"));
// 	}

	propcore->fromMap(othersettingsmap);
	VPN* prop = dynamic_cast<VPN*>(propcore);
	prop->setSecrets(mypwds);
	_conn->slotSecretsProvided(prop);
	TQDialog::done(0);
}

void VPNAuthenticationDialog::setPasswords(TQString name, TQString value) {
	if (value.length() > 0) {
		chkStorePasswordsPermanent->setChecked(true);
		_vpnAuthWidget->setPasswords(name, value);
	}
}

void VPNAuthenticationDialog::cancel()
{
/*
	TQStringList x;
	emit done (true, x, false, false);
	TQDialog::done(1);*/

	printf("Attempting to deactivate VPN connection...\n");

	// Disconnect the attempted connection
	_conn->slotSecretsError();

	// Quit the dialog
	TQDialog::done(1);
}

#include "knetworkmanager-vpnauthenticationdialog.moc"
