/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_IPV4_WIDGET_H
#define KNETWORKMANAGER_CONNECTION_SETTING_IPV4_WIDGET_H

// qt autogenerated headers
#include "connection_setting_ipv4.h"

// knetworkmanager headers
#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_setting_widget_interface.h"
#include "knetworkmanager-connection_setting_ipv4.h"

namespace ConnectionSettings
{
	class IPv4;

	class IPv4WidgetImpl : public WidgetInterface 
	{
		Q_OBJECT
  TQ_OBJECT

		public:
			IPv4WidgetImpl(Connection* conn, TQWidget* parent = 0, const char* name = 0, WFlags fl = 0);
			void Activate();

		public slots:
			void slotIPConfigEnabled(bool);
			void slotIPAddressChanged(const TQString&);
			void slotNetmaskChanged(const TQString&);
			void slotGatewayChanged(const TQString&);
			void slotDNSSearchChanged(const TQString&);
			void slotDNSAddressesChanged(const TQString&);

		private:
			void Init();

			IPv4* _ipv4_setting;
			ConnectionSettingIPv4Widget* _mainWid;
	};

}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_IPv4_WIDGET_H*/
