/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig        <thoenig@suse.de>, <thoenig@nouse.net>
 *         Valentine Sinitsyn <e_val@inbox.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// qt headers
#include <tqwidget.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqlayout.h>

// knm headers
#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_setting_info.h"
#include "knetworkmanager-connection_setting_info_widget.h"
#include "knetworkmanager-device.h"

using namespace ConnectionSettings;

InfoWidgetImpl::InfoWidgetImpl(Connection* conn, TQWidget* parent, const char* name, WFlags fl)
	: WidgetInterface(parent, name, fl)
{
	_infosetting = dynamic_cast<ConnectionSettings::Info*> (conn->getSetting(NM_SETTING_CONNECTION_SETTING_NAME));


	TQVBoxLayout* layout = new TQVBoxLayout(this, 1, 1);
	_mainWid = new ConnectionSettingInfoWidget(this);
	layout->addWidget(_mainWid);

	Init();
}

void
InfoWidgetImpl::Init()
{
	connect(_mainWid->txtConnectionName, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(slotNameChanged(const TQString&)));
	connect(_mainWid->chkAutoConnect, TQT_SIGNAL(toggled(bool)), this, TQT_SLOT(slotAutoconnectChanged(bool)));
}

void
InfoWidgetImpl::Activate()
{
	_mainWid->txtConnectionName->setText(_infosetting->getName());
	_mainWid->chkAutoConnect->setChecked(_infosetting->getAutoconnect());
}

void
InfoWidgetImpl::slotNameChanged(const TQString& name)
{
	_infosetting->setName(name);
}

void
InfoWidgetImpl::slotAutoconnectChanged(bool autoconnect)
{
	_infosetting->setAutoconnect(autoconnect);
}

#include "knetworkmanager-connection_setting_info_widget.moc"
