/***************************************************************************
 *
 * knetworkmanager-connection_setting_cdma_widget.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// qt headers
#include <tqwidget.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqcombobox.h>
#include <tqiconset.h>
#include <kiconloader.h>
#include <tqwidgetstack.h>
#include <kuser.h>

// knm headers
#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_setting_cdma.h"
#include "knetworkmanager-connection_setting_cdma_widget.h"
#include "knetworkmanager-device.h"

#include "connection_setting_cdma.h"

using namespace ConnectionSettings;

CDMAWidgetImpl::CDMAWidgetImpl(Connection* conn, TQWidget* parent, const char* name, WFlags fl)
	: WidgetInterface(parent, name, fl)
{
	_cdmasetting = dynamic_cast<ConnectionSettings::CDMA*> (conn->getSetting(NM_SETTING_CDMA_SETTING_NAME));

	TQVBoxLayout* layout = new TQVBoxLayout(this, 1, 1);
	_mainWid = new ConnectionSettingCdmaWidget(this);
	layout->addWidget(_mainWid);

	Init();
}

void
CDMAWidgetImpl::Init()
{
    _mainWid->mUsername->setText( _cdmasetting->getUsername() );
    _mainWid->mPassword->setText( _cdmasetting->getPassword( ) );
    _mainWid->mNumber->setText( _cdmasetting->getNumber() );
    connect( _mainWid->mUsername, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(dirty()));
    connect( _mainWid->mPassword, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(dirty()));
    connect( _mainWid->mNumber, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(dirty()));
}

void
CDMAWidgetImpl::Deactivate()
{
}

void
CDMAWidgetImpl::Activate()
{

}

void
CDMAWidgetImpl::dirty()
{
    _cdmasetting->setUsername( _mainWid->mUsername->text() );
    _cdmasetting->setPassword( _mainWid->mPassword->text() );
    _cdmasetting->setNumber( _mainWid->mNumber->text() );
}


#include "knetworkmanager-connection_setting_cdma_widget.moc"
