/***************************************************************************
 *
 * knetworkmanager-accesspoint.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// TQt
#include <tqguardedptr.h>

// TQT_DBus includes
#include <tqdbuserror.h>
#include <tqdbusconnection.h>
#include <tqdbuserror.h>

// NM includes
#include <NetworkManager.h>

// KNM includes
#include "knetworkmanager.h"
#include "knetworkmanager-accesspoint.h"
#include "dbus/accesspointproxy.h"

class AccessPointPrivate
{
public:
	AccessPointPrivate(TQString objpath = TQString(), const DBus::AccessPointProxy* proxy = NULL)
		: nmAccessPoint(proxy)
		, objPath(objpath)
	{
	}

	~AccessPointPrivate() { }

	// pointer to the shared DBus proxy
	TQGuardedPtr<const DBus::AccessPointProxy> nmAccessPoint;
	// DBus object path
	TQString objPath;

	// Properties
	TQ_UINT32 flags;
	TQ_UINT32 wpaFlags;
	TQ_UINT32 rsnFlags;
	TQValueList<TQ_UINT8> ssid;
	TQ_UINT32 freq;
	TQString  hwAddress;
	TQ_INT32  mode;
	TQ_UINT32 rate;
	TQ_UINT8  strength;
};

TQ_UINT32 AccessPoint::getFlags() const
{
	return d->flags;
}

TQ_UINT32 AccessPoint::getWpaFlags() const
{
	return d->wpaFlags;
}

TQ_UINT32 AccessPoint::getRsnFlags() const
{
	return d->rsnFlags;
}

TQValueList<TQ_UINT8> AccessPoint::getSsid() const
{
	return d->ssid;
}

TQ_UINT32 AccessPoint::getFrequency() const
{
	return d->freq;
}

TQString AccessPoint::getHwAddress() const
{
	return d->hwAddress;
}

TQ_INT32 AccessPoint::getMode() const
{
	return d->mode;
}

TQ_UINT32 AccessPoint::getRate() const
{
	return d->rate;
}

TQ_UINT8 AccessPoint::getStrength() const
{
	return d->strength;
}

const TQByteArray AccessPoint::getSsidByteArray() const
{
	// FIXME: Wow, thats ugly
	TQValueList<TQ_UINT8> ssid = d->ssid;
	TQByteArray ret_ssid(ssid.count());
	TQByteArray::Iterator byteit = ret_ssid.begin();
	for (TQValueList<TQ_UINT8>::iterator it = ssid.begin(); it != ssid.end(); ++it)
	{
		(*byteit) = (*it);
		++byteit;
	}
	return ret_ssid;
}

TQString AccessPoint::getDisplaySsid() const
{
	return TQString(getSsidByteArray());
}

bool AccessPoint::isEncrypted() const
{
	return (getFlags() && NM_802_11_AP_FLAGS_PRIVACY);
}

void AccessPoint::slotPropertiesChanged(const TQMap<TQString, TQT_DBusVariant>& properties)
{
	updateProperties();
}

void AccessPoint::updateProperties()
{
	//TODO do this proper-like
	TQT_DBusError err;
	if (d->nmAccessPoint.isNull())
		return;

	d->flags = d->nmAccessPoint->getFlags(err);
	d->wpaFlags = d->nmAccessPoint->getWpaFlags(err);
	d->rsnFlags = d->nmAccessPoint->getRsnFlags(err);
	d->ssid = d->nmAccessPoint->getSsid(err);
	d->freq = d->nmAccessPoint->getFrequency(err);
	d->hwAddress = d->nmAccessPoint->getHwAddress(err);
	d->mode = d->nmAccessPoint->getMode(err);
	d->rate = d->nmAccessPoint->getMaxBitrate(err);
	d->strength = d->nmAccessPoint->getStrength(err);
	emit strengthChanged(d->strength);
}

TQString AccessPoint::getObjectPath() const
{
	return d->objPath;
}

bool AccessPoint::isValid() const
{
	return !(d->objPath.isEmpty());
}

bool AccessPoint::operator== (const AccessPoint& other) const
{
	return (other.getObjectPath() == getObjectPath());
}
#if 0
AccessPoint& AccessPoint::operator= (const AccessPoint& other)
{
	kdDebug() << "AccessPoint::operator=\n" << endl;
	d->objPath = other.d->objPath;
	d->nmAccessPoint = other.d->nmAccessPoint;
	connect(d->nmAccessPoint, TQT_SIGNAL(PropertiesChanged(const TQMap<TQString, TQT_DBusVariant>&)), this, TQT_SLOT(slotPropertiesChanged(const TQMap<TQString, TQT_DBusVariant>&)));

	updateProperties();

	return *this;
}
#endif
AccessPoint::AccessPoint(TQString obj_path, TQObject * parent, const char * name)
: TQObject(parent, name)
{
	DBus::AccessPointProxy * proxy = new DBus::AccessPointProxy(NM_DBUS_SERVICE, obj_path);
	proxy->setConnection(TQT_DBusConnection::systemBus());
	d = new AccessPointPrivate(obj_path, proxy);

	if (!d->nmAccessPoint.isNull())
		connect(d->nmAccessPoint, TQT_SIGNAL(PropertiesChanged(const TQMap<TQString, TQT_DBusVariant>&)), this, TQT_SLOT(slotPropertiesChanged(const TQMap<TQString, TQT_DBusVariant>&)));

	updateProperties();
}
#if 0
// copy constructor
AccessPoint::AccessPoint(const AccessPoint& other)
	: TQObject()
{
	// just copy the private data from other
	d = new AccessPointPrivate(*other.d);

	if (!d->nmAccessPoint.isNull())
		connect(d->nmAccessPoint, TQT_SIGNAL(PropertiesChanged(const TQMap<TQString, TQT_DBusVariant>&)), this, TQT_SLOT(slotPropertiesChanged(const TQMap<TQString, TQT_DBusVariant>&)));

	updateProperties();
}
#endif
AccessPoint::~AccessPoint()
{
	delete d->nmAccessPoint;
	delete d;
}


#include "knetworkmanager-accesspoint.moc"
