/*
Copyright 2008 Will Stephenson <wstephenson@kde.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License or (at your option) version 3 or any later version
accepted by the membership of KDE e.V. (or its successor approved
by the membership of KDE e.V.), which shall act as a proxy 
defined in Section 14 of version 3 of the license.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef DEVICE_TRAY_COMPONENT_H
#define DEVICE_TRAY_COMPONENT_H

#include <NetworkManager.h>

#include <tqmap.h>
#include <tqmovie.h>
#include <tqobject.h>
#include <tqpixmap.h>

#include "traycomponent.h"

class Device;
class KPopupMenu;
class KSystemTray;

class DeviceTrayComponent : public TrayComponent
{
Q_OBJECT
  TQ_OBJECT
public:
    DeviceTrayComponent(Device * device, KSystemTray * parent, const char * name );
    virtual ~DeviceTrayComponent();
    TQPixmap pixmapForState(NMDeviceState state);
    TQMovie movieForState(NMDeviceState state);
    virtual TQStringList getToolTipText();
    Device* device() const;
signals:
    void needsCenterStage(TrayComponent *, bool);
public slots:
    virtual void newConnection() = 0;
protected slots:
    void deviceStateChanged(NMDeviceState);
protected:
    void setMovieForState(NMDeviceState, TQString);
    void setPixmapForState(NMDeviceState, TQString);
private:
    Device * m_device;
    TQMap<NMDeviceState, TQString> m_movies;
    TQMap<NMDeviceState, TQString> m_pixmaps;
    TQMap<NMDeviceState, TQString> m_tooltips;
};
#endif // DEVICE_TRAY_COMPONENT_H
