/***************************************************************************
begin                : Sun May 26 2002
copyright            : (C) 2002 by Christian Hubinger
email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleeditortargetnat.h"

// QT includes
#include <tqstring.h>
#include <tqspinbox.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqmessagebox.h>

// KDE include
#include <kdebug.h>
#include <klocale.h>
#include <kapplication.h>
#include <kmessagebox.h>

// MY includes
#include "../../core/xmlnames.h"
#include "../../core/iptrule.h"
#include "../../core/iptchain.h"
#include "../../core/iptable.h"
#include "../../core/iptruleoption.h"
#include "../../core/kmfdoc.h"
#include "../../core/kmfiptdoc.h"
#include "../../core/kmferror.h"
#include "../../core/kmfcheckinput.h"
#include "../../core/kmferrorhandler.h"
#include "../../core/kmfnetwork.h"
#include "../../core/kmfundoengine.h"
namespace KMF {
KMFRuleEditorTargetNat::KMFRuleEditorTargetNat( TQWidget *parent, const char *name, WFlags fl ) : KMyFirewallRuleEditorTargetNat( parent, name, fl ) {
	m_CheckInput = new KMFCheckInput();
	m_ErrorHandler = new KMFErrorHandler( "KMFRuleEditProtocol" );
	m_err = new KMFError() ;

}



KMFRuleEditorTargetNat::~KMFRuleEditorTargetNat() {}

void KMFRuleEditorTargetNat::loadRule( IPTRule *rule ) {
	c_use_ports->setChecked( false );
	c_use_port_range->setChecked( false );
	c_ip_range->setChecked( false );
	t_ip1->clear();
	t_ip2->clear();
	sb_port1->setValue(1);
	sb_port2->setValue(2);
	m_rule = rule;

	kdDebug() << "KMFRuleEditorTargetNat::loadRule(IPTRule *rule)" << endl;
	m_rule = rule;
	bool has_port = false;
	IPTRuleOption *opt = m_rule->getOptionForName( "tcp_opt" );
	if ( ! opt->isEmpty() )
		has_port = true;
	if ( ! has_port ) {
		opt = m_rule->getOptionForName( "udp_opt" );
		if ( ! opt->isEmpty() )
			has_port = true;
	}
	if ( ! has_port ) {
		opt = m_rule->getOptionForName( "tcp_multiport_opt" );
		if ( ! opt->isEmpty() )
			has_port = true;
	}
	if ( ! has_port ) {
		opt = m_rule->getOptionForName( "udp_multiport_opt" );
		if ( ! opt->isEmpty() )
			has_port = true;
	}
	c_use_ports->setEnabled( has_port );

	if ( mbsnat )
		opt = m_rule->getOptionForName( "target_snat_opt" );
	else
		opt = m_rule->getOptionForName( "target_dnat_opt" );

	TQStringList vals;
	vals = opt->getValues();
	TQString arg = "";
	arg = *vals.at( 0 );
	kdDebug() << "Found option String: " << arg << endl;
	if ( arg != XML::Undefined_Value && !arg.isEmpty() && arg != XML::BoolOff_Value ) {
		kdDebug() << "Found option String: " << arg << endl;
		TQString ips = "";
		TQString ports = "";
		TQString ip1 = "";
		TQString ip2 = "";
		TQString port1 = "";
		TQString port2 = "";
		if ( arg.contains( ":" ) && has_port ) {
			c_use_ports->setChecked( true );
			int del = arg.find( ':' );
			ips = arg.left( del );
			kdDebug() << "IP arg: " << ips << endl;
			ports = arg.right( arg.length() - del - 1 );
			kdDebug() << "Port arg: " << ports << endl;
			if ( ips.contains( "-" ) ) {
				c_ip_range->setChecked( true );
				int delim = ips.find( '-' );

				ip1 = ips.left( delim );
				kdDebug() << "IP arg1: " << ip1 << endl;
				t_ip1 ->setText( ip1 );

				ip2 = ips.right( ips.length() - delim - 1 );
				kdDebug() << "IP arg2: " << ip2 << endl;
				t_ip2 ->setText( ip2 );
			} else {
				c_ip_range->setChecked( false );
				t_ip1 ->setText( ips );
			}
			if ( ports.contains( "-" ) ) {
				c_use_port_range->setChecked( true );

				int delim = ports.find( '-' );
				port1 = ports.left( delim );
				kdDebug() << "Port arg1: " << port1 << endl;
				;
				int int_port1 = port1.toInt();
				sb_port1 ->setValue( int_port1 );

				port2 = ports.right( ports.length() - delim - 1 );
				kdDebug() << "Port arg2: " << port2 << endl;
				;
				int int_port2 = port2.toInt();
				sb_port2 ->setValue( int_port2 );

			} else {
				c_use_port_range->setChecked( false );
				kdDebug() << "Port arg: " << ports << endl;
				;
				int int_port1 = ports.toInt();
				sb_port1 ->setValue( int_port1 );
			}
		} else if ( arg.contains( "-" ) ) {
			c_use_ports->setChecked( false );
			c_ip_range->setChecked( true );
			int delim = arg.find( '-' );
			ip1 = arg.left( delim );
			kdDebug() << "IP arg1: " << ip1 << endl;
			t_ip1 ->setText( ip1 );
			ip2 = arg.right( arg.length() - delim - 1 );
			kdDebug() << "IP arg2: " << ip2 << endl;
			t_ip2 ->setText( ip2 );
		} else if ( ! arg.isEmpty() ){
			c_use_ports->setChecked( false );
			c_ip_range->setChecked( false );
			ip1 = arg;
			t_ip1 ->setText( ip1 );
		} else {
			c_use_ports->setChecked( false );
			c_ip_range->setChecked( false );
			t_ip1 ->clear();
			t_ip2 ->clear();
		}
	}
}


void KMFRuleEditorTargetNat::accept() {
	kdDebug() << "KMFRuleEditorTargetNat::accept()";
	KMFUndoEngine::instance()->startTransaction( 
		m_rule,
		i18n("Edit Rule: %1 Target NAT Option").arg( m_rule->name() ) 
	);

	bool ip_range = c_ip_range->isChecked();
	bool use_ports = c_use_ports->isChecked();
	bool use_port_range = c_use_port_range->isChecked();
	TQString ip1, ip2, port1, port2, arg_ip, arg_port;

	if ( ip_range ) {
		ip1 = t_ip1->text();
		ip2 = t_ip2->text();
		if ( ip1.isEmpty() ) {
			KMessageBox::sorry(this,i18n("You need as a minimum to define an IP address to make NAT working."),
												i18n("Argument not Valid"));
				KMFUndoEngine::instance()->abortTransaction();
				return;
		}
		if ( ip2.isEmpty() ) {
			KMessageBox::sorry(this,i18n("Please also set the upper boundary for your address range.."),
												i18n("Argument not Valid"));
				KMFUndoEngine::instance()->abortTransaction();
				return;
		}

		// Sanity checks +++++++++++++++++
		m_CheckInput->checkInput( ip1, "IP", m_err );
		if ( !m_ErrorHandler->showError( m_err ) ) {
			KMFUndoEngine::instance()->abortTransaction();
			return ;
		}
		m_CheckInput->checkInput( ip2, "IP", m_err );
		if ( !m_ErrorHandler->showError( m_err ) ) {
			KMFUndoEngine::instance()->abortTransaction();
			return ;
		}
		// ++++++++++++++++++++++++++++++++
		arg_ip = ip1 + "-" + ip2;
		kdDebug() << "IP Argument: " << arg_ip;
	} else {
		ip1 = t_ip1->text();
		// Sanity checks +++++++++++++++++
		m_CheckInput->checkInput( ip1, "IP", m_err );
		if ( !m_ErrorHandler->showError( m_err ) ) {
			KMFUndoEngine::instance()->abortTransaction();
			return ;
		}
		// ++++++++++++++++++++++++++++++++
		arg_ip = ip1;
		kdDebug() << "IP Argument: " << arg_ip;
	}

	if ( use_ports && c_use_ports->isEnabled() ) {
		if ( use_port_range ) {
			port1 = sb_port1->text();
			port2 = sb_port2->text();
			// Sanity checks +++++++++++++++++
			m_CheckInput->checkInput( port1, "PORT", m_err );
			if ( !m_ErrorHandler->showError( m_err ) ) {
				KMFUndoEngine::instance()->abortTransaction();
				return ;
			}
			m_CheckInput->checkInput( port2, "PORT", m_err );
			if ( !m_ErrorHandler->showError( m_err ) ) {
				KMFUndoEngine::instance()->abortTransaction();
				return ;
			}
			// ++++++++++++++++++++++++++++++++
			arg_port = port1 + "-" + port2;
			kdDebug() << "Port Argument: " << arg_port;
		} else {
			port1 = sb_port1->text();
			// Sanity checks +++++++++++++++++
			m_CheckInput->checkInput( port1, "PORT", m_err );
			if ( !m_ErrorHandler->showError( m_err ) ) {
				KMFUndoEngine::instance()->abortTransaction();
				return ;
			}
			// ++++++++++++++++++++++++++++++++

			arg_port = port1;
			kdDebug() << "Port Argument: " << arg_port;
		}
	}

	if ( mbsnat ) {
		TQPtrList<TQString>* options = new TQPtrList<TQString>;
		TQString* name = new TQString( "target_snat_opt" );
		TQString val = arg_ip;
		TQString arg = "";
		if ( !val.isEmpty() ) {
			arg.append( val );
		} else {
			KMessageBox::sorry( this, i18n( "Unable to work without values.\n"
			                             "Please specify at least an IP address." ) ,
										  i18n( "Nat Options" ) );
			KMFUndoEngine::instance()->abortTransaction();
			return ;
		}

		TQString val2 = arg_port;
		if ( !val2.isEmpty() ) {
			arg.append( ":" );
			arg.append( val2 );
		}
		options->append( new TQString( arg ) );
		// emit sigAddTargetOpt( name, options );
		m_rule->addTargetOption( *name, *options );

	} else {
		TQPtrList<TQString>* options = new TQPtrList<TQString>;
		TQString* name = new TQString( "target_dnat_opt" );
		TQString val = arg_ip;
		TQString arg = "";
		if ( !val.isEmpty() ) {
			arg.append( val );
		} else {
			KMessageBox::sorry( this, i18n( "Unable to work without values.\n"
			                             "Please specify at least an IP address." ) ,
										  i18n( "Nat Options" ) );
			KMFUndoEngine::instance()->abortTransaction();
			return ;
		}
		TQString val2 = arg_port;
		if ( !val2.isEmpty() ) {
			arg.append( ":" );
			arg.append( val2 );
		}
		options->append( new TQString( arg ) );
		m_rule->addTargetOption( *name, *options );
	}

	KMFUndoEngine::instance()->endTransaction();
	emit sigDocumentChanged();
}
void KMFRuleEditorTargetNat::slotHelp() {
	kdDebug() << "void KMFRuleEditorTargetNat::slotHelp()" << endl;
	kapp->invokeHelp( "targets" );
}
void KMFRuleEditorTargetNat::reject() {
	kdDebug() << "void KMFRuleEditorTargetNat::reject()" << endl;
	loadRule(m_rule);
	emit sigHideMe();
}

}

#include "kmfruleeditortargetnat.moc"
