//
// C++ Implementation: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfruletargetoptioneditmark.h"


// QT includes
#include <tqstring.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>

// Project includes
#include "../../core/iptrule.h"
#include "../../core/kmfruleeditinterface.h"
#include "kmfruleedittargetmark.h"

namespace KMF {
KMFRuleTargetOptionEditMark::KMFRuleTargetOptionEditMark(TQObject *parent, const char *name)
		: KMFRuleTargetOptionEditInterface(parent, name) {
	kdDebug() <<"KMFRuleTargetOptionEditMark::KMFRuleTargetOptionEditMark(TQObject *parent, const char *name)" << endl;
	
	m_managedTargets << "MARK";
	
	
	kdDebug() << "Parent has Type: " << parent->className()  << endl;
	
	m_edit = new KMFRuleEditTargetMark( 0 , "Edit", 0 );
	m_edit->hide();

/*	connect( m_edit,TQT_SIGNAL(sigAddRuleOpt(TQString*, TQPtrList< TQString >* ) ), 
		this,TQT_SLOT( slotAddRuleOption(TQString*, TQPtrList< TQString >* ) ) );
	connect( m_edit,TQT_SIGNAL(sigAddTargetOpt(TQString*, TQPtrList< TQString >* ) ), 
		this,TQT_SLOT( slotAddTargetOption(TQString*, TQPtrList< TQString >* ) ) );*/
	connect( m_edit,TQT_SIGNAL(sigHideMe() ), 
		this,TQT_SLOT( slotShowOverview() ) );
}

KMFRuleTargetOptionEditMark::~KMFRuleTargetOptionEditMark() {}

void KMFRuleTargetOptionEditMark::slotShowOverview() {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->showOverview();
	} else {
		kdDebug() << "KMFRuleTargetOptionEditMark::slotShowOverview(): parent() not of type KMFRuleEditInterface" << endl;
	}
}


const TQString& KMFRuleTargetOptionEditMark::optionEditName() const {
	return *( new TQString( i18n("NAT Option") ) );
}
const TQString& KMFRuleTargetOptionEditMark::description() const {
	return *( new TQString( i18n("This plugin manages the NAT options of iptables.") ) );
}

void KMFRuleTargetOptionEditMark::loadRule( IPTRule* rule ) {
	if ( !rule ) {
		kdDebug() << "KMFRuleTargetOptionEditMark::loadRule( IPTRule* rule ) - rule == 0" << endl;
		return;
	}
	
	m_edit->loadRule( rule );
	m_rule = rule;

}

TQWidget* KMFRuleTargetOptionEditMark::editWidget() {
	if ( ! m_edit ) {
		kdDebug() << "KMFRuleTargetOptionEditMark::editWidget() - m_edit == 0" << endl;
		return 0;
	}
	return m_edit;
}

bool KMFRuleTargetOptionEditMark::setTarget( const TQString& target ){
	if ( ! manageTarget( target ) ) {
		return false;
	}
	return true;
}



// It's usually safe to leave the factory code alone.. with the
// notable exception of the KAboutData data
#include <kaboutdata.h>
#include <klocale.h>

// KInstance* KMFRuleTargetOptionEditMarkFactory::s_instance = 0L;
// KAboutData* KMFRuleTargetOptionEditMarkFactory::s_about = 0L;

KMFRuleTargetOptionEditMarkFactory::KMFRuleTargetOptionEditMarkFactory( TQObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new KInstance( "KMFRuleTargetOptionEditMarkFactory" );
}

TQObject* KMFRuleTargetOptionEditMarkFactory::createObject( TQObject* parent, const char* name,
        const char*, const TQStringList & ) {
	TQObject * obj = new KMFRuleTargetOptionEditMark( parent, name );
	emit objectCreated( obj );
	return obj;
}


// KInstance* KMFRuleTargetOptionEditMarkFactory::instance() {
// 	if ( !s_instance ) {
// 		s_instance = new KInstance( "KMFRuleTargetOptionEditMarkFactory" );
// 	}
// 	return s_instance;
// }

extern "C" {
	void* init_libkmfruletargetoptionedit_mark() {
		return new KMFRuleTargetOptionEditMarkFactory;
	}
}


}

#include "kmfruletargetoptioneditmark.moc"
