/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2004
*/


#ifndef KMFRULEEDITMAC_H
#define KMFRULEEDITMAC_H

#include "kmyfirewallruleeditormac.h"

#include <tqvariant.h>
#include <tqdialog.h>
#include <tqptrlist.h>

namespace KMF {
class IPTRule;
class KMFErrorHandler;
class KMFCheckInput;
class KMFError;

class KMFRuleEditMac : public KMyFirewallRuleEditorMac {
	Q_OBJECT
  TQ_OBJECT

public:
	KMFRuleEditMac( TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~KMFRuleEditMac();

	void loadRule( IPTRule* );

public slots:
	void accept();
	void slotHelp();
	void reject();

protected:
	bool event( TQEvent* );

private:
	KMFCheckInput *m_check_input;
	KMFErrorHandler *m_err_handler;
	KMFError *m_err;
	IPTRule* m_rule;

signals:
/*	void sigAddRuleOpt( TQString*, TQPtrList<TQString>* );
	void sigAddTargetOpt( TQString*, TQPtrList<TQString>* );*/
	void sigHideMe();
};
}
#endif // KMFRULEEDITMAC_H
