/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
// C++ Interface: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFRULEOPTIONEDITCUSTOM_H
#define KMFRULEOPTIONEDITCUSTOM_H

#include "../../core/kmfruleoptioneditinterface.h"

// QT includes
#include <tqobject.h>
#include <tqptrlist.h>
#include <tqstring.h>

// KDE includes
#include <kparts/part.h>
#include <kparts/plugin.h>
#include <kparts/factory.h>
#include <kxmlgui.h>
class KInstance;

namespace KMF {
class IPTRule;
class KMFRuleEditCustomOpt;
/**
@author Christian Hubinger
*/
class KMFRuleOptionEditCustom : public KMFRuleOptionEditInterface {
	Q_OBJECT
  TQ_OBJECT
public:
	KMFRuleOptionEditCustom(TQObject *parent = 0, const char *name = 0, const TQStringList& = TQString());

	~KMFRuleOptionEditCustom();
	void loadRule( IPTRule* rule );	
	TQWidget* editWidget();
	const TQString& optionEditName() const;
	const TQString& description() const;
	static KAboutData *createAboutData();

private slots:
	void slotShowOverview();
	
private:
	KMFRuleEditCustomOpt *m_edit;
	IPTRule *m_rule;
};



class KMFRuleOptionEditCustomFactory : public KLibFactory {
	Q_OBJECT
  TQ_OBJECT
public:
	KMFRuleOptionEditCustomFactory( TQObject *parent = 0, const char *name = 0 );
	virtual ~KMFRuleOptionEditCustomFactory() {
/* 		delete s_instance; */
	};
	virtual TQObject* createObject( TQObject* parent = 0, const char* pname = 0,
	                               const char* name = TQOBJECT_OBJECT_NAME_STRING,
	                               const TQStringList &args = TQStringList() );
	/*     static KInstance* instance(); */

/*private:
	static KInstance* s_instance;*/
};
}








#endif
