//
// C++ Interface:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
// License: GPL
//

#ifndef KMFTEMPLATECHOOSER_H
#define KMFTEMPLATECHOOSER_H

#include "kmyfirewalltemplatechooser.h"

// TQt includes
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqptrlist.h>

// KDE includes
#include <kdemacros.h>

// project includes


class TQListBoxItem;
namespace KMF {
class KDE_EXPORT KMFTemplateChooser : public KMyFirewallTemplateChooser {
	Q_OBJECT
  TQ_OBJECT

public:
	KMFTemplateChooser(TQWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
	~KMFTemplateChooser();
	/*$PUBLIC_FUNCTIONS$*/

	void setFileExtention( const TQString& = "kmfrs" );
	
	
public slots:
	/*$PUBLIC_SLOTS$*/
	void parseTemplates();
	
protected:
	/*$PROTECTED_FUNCTIONS$*/

protected slots:
	/*$PROTECTED_SLOTS$*/
	virtual void          reject();
	virtual void          accept();
	void          slotHelp();
	void slotNewTemplateSelected( int );
	void slotNewTemplateSelected( TQListBoxItem* );
	
private:
	
	void parseFile( const TQString& );
	
private: // data
	TQStringList m_templateDescriptions;
	TQStringList m_templateFilePaths;
	
signals:
    void sigLoadTemplate( const TQString& );
    void sigLoadEmptyDocument();
 		
};
}
#endif

