//
// C++ Interface: 
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef KMFMYNETWORKWIDGET_H
#define KMFMYNETWORKWIDGET_H

#include "kmyfirewallmynetworkwidget.h"

#include <tqwidget.h>
#include <kdialogbase.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kprocess.h>
#include <tqstring.h>
#include <tqpixmap.h>
#include <tqguardedptr.h>
#include <tquuid.h>
class KPopupMenu;
class TQTextEdit;


namespace KMF {
class KMFHostWidget;
class KMFInterfaceWidget;
class KMFSystemSettingsLinux;
class KMFNetworkWidget;
class KMFNetZone;
class KMFNetwork;
class KMFTarget;
class KMFListViewItem;
class NetfilterObject;

class KMFMyNetworkWidget : public KMyFirewallMyNetworkWidget
{
  Q_OBJECT
  TQ_OBJECT

public:
  KMFMyNetworkWidget(TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~KMFMyNetworkWidget();
  /*$PUBLIC_FUNCTIONS$*/
  void saveConfig();
	void setNetwork( KMFNetwork* );
  
public slots:
  /*$PUBLIC_SLOTS$*/
	void slotUpdateView();
	void slotUpdateView( NetfilterObject* );
signals:
	void sigActiveTargetChanged();

protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
	void slotZoneRBM( TQListViewItem*, const TQPoint&, int );
	void slotNewItemSelected( TQListViewItem* );
	void slotAddHost();
	void slotDelHost();
	void slotAddZone();
	void slotDelZone();
	void slotRenameItem( TQListViewItem* item, int, const TQString& name );
	void slotRenameZone();
	void slotRenameHost();
	void slotZoneChanged( KMFNetZone* );
	void slotTargetChanged();
	void slotSetActiveTarget();
	
	private:
		void setupPropertiesView();
		void loadIcons();
		KMFListViewItem* findItem( const TQUuid& obj_id );
		
	private:
		KMFHostWidget *m_hostProperties;	
		KMFInterfaceWidget *m_hostInterfaces;	
		KMFSystemSettingsLinux *m_hostSettingsLinux;	
		
		TQPixmap icon_up, icon_down, icon_del, icon_edit, icon_rule, icon_filter, icon_rename,
		icon_chain, icon_log, icon_accept, icon_drop, icon_cmd, icon_reject, icon_return,
		icon_target, icon_queue, icon_new, icon_copy, icon_move;
		
		
		// KMFNetZone *m_globalzone;
		// KMFTarget *m_localhost;
		
		TQGuardedPtr<KMFNetwork> m_network;
		TQGuardedPtr<KMFNetZone> m_zone;
		TQGuardedPtr<KMFTarget> m_target;
		
		// TQTextEdit* m_zone_desc;
		KMFNetworkWidget* m_network_widget; 
		// TQWidget *ws_pageZoneProperties;
		KPopupMenu* m_contextMenu;
};
}
#endif

