/***************************************************************************
  begin                : Fri Nov 1 2002
  copyright            : (C) 2002 by Christian Hubinger
  email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfmultiportwidget.h"


#include <tqstring.h>
#include <tqspinbox.h>
#include <tqlistbox.h>
#include <tqcheckbox.h>
#include <tqradiobutton.h>

#include <kpushbutton.h>

#include "../core/kmferror.h"
namespace KMF {
KMFMultiPortWidget::KMFMultiPortWidget( TQWidget *parent, const char *name ) : KMyFirewallMultiPortWidget( parent, name ) {
	m_err = new KMFError();
	m_err->setErrType( KMFError::OK );
	lb_ports->clear();
	connect( b_add, TQT_SIGNAL( clicked() ), this, TQT_SLOT( addPort() ) );
	connect( b_remove, TQT_SIGNAL( clicked() ), this, TQT_SLOT( removePort() ) );
	connect( c_use_multiport, TQT_SIGNAL( toggled( bool ) ), this, TQT_SIGNAL( sigMultiPortChanged( bool ) ) );
}
KMFMultiPortWidget::~KMFMultiPortWidget() {}

void KMFMultiPortWidget::addPort() {
	TQString port = "";
	port.setNum( sb_port->value() );
	if ( port.isEmpty() )
		return ;
	if ( lb_ports->count() > 14 )
		return ;

	for ( uint i = 0; i < lb_ports->count(); i++ )
		if ( lb_ports->text( i ) == port )
			return ;

	lb_ports->insertItem( port );
}

void KMFMultiPortWidget::addPort( TQString& port ) {
	lb_ports->insertItem( port );
}

void KMFMultiPortWidget::removePort() {
	int index = -1;
	index = lb_ports->currentItem();
	if ( index > -1 )
		lb_ports->removeItem( index );
}

void KMFMultiPortWidget::removePort( int index ) {
	lb_ports->removeItem( index );
}

KMFError* KMFMultiPortWidget::getPortString( TQString* value ) {
	for ( uint i = 0; i < lb_ports->count(); i++ ) {
		if ( !(*value).isEmpty() )
			value->append( "," );
		value->append( lb_ports->text( i ) );
	}
	if ( value->isEmpty() )
		return m_err;

	value->stripWhiteSpace();
	return m_err;
}

void KMFMultiPortWidget::setType( const TQString& type ) {
	setEnabled( true );
	c_use_multiport->setChecked( true );
	if ( type == "src" )
		rb_src->setChecked( true );
	if ( type == "dest" )
		rb_dest->setChecked( true );
	if ( type == "equ" )
		rb_equ->setChecked( true );

}

void KMFMultiPortWidget::loadPortString( TQString& str ) {
	if ( str.isEmpty() )
		return ;
	lb_ports->clear();
	int pos = -1;
	pos = str.find( "," );
	while ( pos > -1 ) {
		TQString port = str.left( pos );
		lb_ports->insertItem( port );
		str = str.right( str.length() - pos - 1 );
		pos = str.find( "," );
	}
	if ( !str.isEmpty() ) {
		lb_ports->insertItem( str );
	}
}

void KMFMultiPortWidget::reset() {
	c_use_multiport->setChecked( false );
	rb_src->setChecked( false );
	rb_dest->setChecked( false );
	rb_equ->setChecked( false );
	lb_ports->clear();
}


TQString& KMFMultiPortWidget::type() const {
	TQString ret = "src";
	if ( rb_src->isChecked() )
		ret = "src";
	else if ( rb_dest->isChecked() )
		ret = "dest";
	else if ( rb_equ->isChecked() )
		ret = "equ";
	TQString *val = new TQString( ret );
	return *val;
}

}

#include "kmfmultiportwidget.moc"
