/***************************************************************************
 begin                : Tue Jul 30 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfchecklistoutput.h"

// QT includs
#include <tqlabel.h>
#include <tqlistbox.h>
#include <tqpushbutton.h>
#include <tqlistview.h>
#include <tqlayout.h>
#include <tqstring.h>

// kde includes
#include <klocale.h>
#include <kdebug.h>
#include <kglobal.h>
#include <kiconloader.h>

namespace KMF {
KMFCheckListOutput::KMFCheckListOutput( TQWidget *parent, const char *name , bool modal, WFlags fl ) : TQDialog( parent, name, modal, fl ) {
	setCaption( "KMyFirewall" );
	TQGridLayout *l_prog = new TQGridLayout( this,4,2,6,11 );
  text = new TQLabel( i18n("<qt><b>Trying to guess the system configuration...</b><br>"
													"If errors are occurring you'll have to setup the configuration yourself."
													"</qt>"), this);
	l_prog -> addMultiCellWidget( text, 0, 0, 0, 2 );

	mpb_ok = new TQPushButton( this, "Ok" );
	mpb_ok->setText( i18n( "&Close Window" ) );
	l_prog -> addMultiCellWidget( mpb_ok, 4, 4, 0, 2 );

	mlb_outputView = new TQListView( this, "msg" );
	mlb_outputView->addColumn( i18n( "Looking For" ) );
	mlb_outputView->addColumn( i18n( "Found?" ) );
	mlb_outputView->setSelectionMode( TQListView::NoSelection );
	mlb_outputView->setSorting( -1 );
	l_prog -> addMultiCellWidget( mlb_outputView, 1, 3, 0, 2 );


	connect( mpb_ok, TQT_SIGNAL( clicked() ) , this, TQT_SLOT( hide() ) );
	m_currItem = new TQListViewItem( mlb_outputView );
	m_currItem->setText( 0, i18n( "Starting system scan..." ) );
	loadIcons();
	this->resize( 450, 450 );
}

KMFCheckListOutput::~KMFCheckListOutput() {}

void KMFCheckListOutput::appendLine( const TQString &txt ) {
	TQListViewItem * item = new TQListViewItem( mlb_outputView, m_currItem );
	item->setMultiLinesEnabled( true );
	item->setText( 0, txt );
	m_currItem = item;
	kdDebug() << "void KMFCheckListOutput::appendLine(TQString txt)" << endl;
}

void KMFCheckListOutput::setStatus( bool ok, const TQString &err_msg ) {
	kdDebug() << "void KMFCheckListOutput::setStatus(bool ok,TQString &err_msg)" << endl;
	if ( ok ) {
		m_currItem->setPixmap( 1, icon_ok );
	} else {
		m_currItem->setPixmap( 1, icon_err );
		m_currItem->setOpen( true );
		if ( !err_msg.isEmpty() ) {
			TQListViewItem * item = new TQListViewItem( m_currItem );
			item->setText( 0, err_msg );
		}
	}
}

void KMFCheckListOutput::clearList() {
	kdDebug() << "void KMFCheckListOutput::clearList()" << endl;
	mlb_outputView->clear();
}

void KMFCheckListOutput::loadIcons() {
	kdDebug() << "void KMFCheckListOutput::loadIcons()" << endl;
	KIconLoader *loader = KGlobal::iconLoader();
	TQString icon_name;

	icon_name = "stop";
	icon_err = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "button_ok";
	icon_ok = loader->loadIcon( icon_name, KIcon::Small );

}

}

#include "kmfchecklistoutput.moc"
