/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001
*/

#ifndef _KMFIPTEDITORPART_H_
#define _KMFIPTEDITORPART_H_

#include <kparts/part.h>
#include <kparts/factory.h>

class TQWidget;
class TQPainter;
class KURL;
class KAction;
class KActionMenu;
class KInstance;
class KAboutData;

namespace KMF {
class KMFRuleEdit;
class KMFIPTDoc;
class KMFIPTDocOptions;

/**
 * This is a "Part".  It that does all the real work in a KPart
 * application.
 *
 * @short Main Part
 * @author Chris <chubinger@irrsinnig.org>
 * @version 0.1
 */
 
class KMFIPTEditorPart : public KParts::ReadWritePart
{
    Q_OBJECT
  TQ_OBJECT
public:
    /**
     * Default constructor
     */
    KMFIPTEditorPart(TQWidget *parentWidget, const char *widgetName,
                    TQObject *parent, const char *name);

    /**
     * Destructor
     */
    virtual ~KMFIPTEditorPart();

    /**
     * This is a virtual function inherited from KParts::ReadWritePart.
     * A shell will use this to inform this Part if it should act
     * read-only
     */
    virtual void setReadWrite(bool rw);

    /**
     * Reimplemented to disable and enable Save action
     */
    virtual void setModified(bool modified);

protected:
    /**
     * This must be implemented by each part
     */
    virtual bool openFile();

    /**
     * This must be implemented by each read-write part
     */
    virtual bool saveFile();

public slots:
	void slotEnableActions( bool );

protected slots:
    void fileOpen();
    void fileSaveAs();
	void slotEditChain();
	void slotNewChain();
	void slotDelChain();
	void slotNewRule();
	void slotDelRule();
	void slotEditDocOptions();
	void slotEditNetwork();
	
private:
    KMFRuleEdit *m_ruleedit;
	KMFIPTDoc* m_doc;
	KMFIPTDocOptions *m_editdoc;
	KAction* m_actionEditNetwork;
	KAction* m_actionEditChain;
	KAction* m_actionNewChain;
	KAction* m_actionNewRule;
	KAction* m_actionDelChain;
	KAction* m_actionDelRule;
	KAction* m_actionEditDocOptions;
};


class KMFIPTEditorPartFactory : public KParts::Factory
{
    Q_OBJECT
  TQ_OBJECT
public:
    KMFIPTEditorPartFactory();
    virtual ~KMFIPTEditorPartFactory();
    virtual KParts::Part* createPartObject( TQWidget *parentWidget, const char *widgetName,
                                            TQObject *parent, const char *name,
                                            const char *classname, const TQStringList &args );
    static KInstance* instance();

private:
    static KInstance* s_instance;
    static KAboutData* s_about;
};

}
#endif // _KMFRULEEDITPART_H_
