/***************************************************************************
 begin                : Mon Jan 28 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KMFIPTINSTALLER_H
#define KMFIPTINSTALLER_H
#include <tqobject.h>
#include <tqpixmap.h>
#include <tqstringlist.h>

#include <kparts/part.h>
#include <kparts/plugin.h>
#include <kparts/factory.h>
#include <kxmlgui.h>



#include "../../core/kmfplugin.h"
#include "../../core/kmfinstallerinterface.h"

#include "../../kmyfirewall.h"
class TQString;
class TQStringList;
class TQLabel;
class TQPushButton;
class TQGridLayout;
class KTempFile;
class KInstance;


namespace KMF {
class KMFProcOut;
class KMFError;
class KMFTarget;
class KMFErrorHandler;
class KMFCompilerInterface;

class KMFIPTInstaller :  public KMFPlugin, public KMFInstallerInterface {
	Q_OBJECT
  TQ_OBJECT

public:
	KMFIPTInstaller( TQObject* parent = 0, const char* name = 0 );
	~KMFIPTInstaller();
	virtual void loadScript( const TQString& );
	virtual KMFCompilerInterface* compiler();
	virtual void cmdRunFW();
	virtual void cmdStopFW();
	virtual void cmdInstallFW();
	virtual void cmdUninstallFW();
	virtual void cmdShowRunningConfig( const TQString& );
	virtual void generateInstallerPackage( KMFTarget*, const KURL& );
	virtual const TQString& osName() const {
		return m_osName;
	}
	virtual const TQString& osGUIName() const {
		return m_osGUIName;
	}
	virtual TQValueList<KMFCompilerInterface*>* compilers();
	
	void generateInstallerPackage( KMFTarget* tg );
	
	
public slots:
	void slotCloseWindow();
	void slotJobFinished( bool, const TQString& );

private: 
	void loadIcons();
	KMFProcOut* execWidget();
	KMFError* createInitScript( const TQString& file, const TQString& systemtype );

	TQString cmdShowAll();
	TQString cmdShowFilter();
	TQString cmdShowNat();
	TQString cmdShowMangle();
	
	void parseFileHeaders( const TQString& source_file_path, const TQString& target_file_path ); 
	void writeBase64DataField( const TQString& source_file_path, const TQString& target_file_path, const TQString& data );
	
	
private:    // data
	TQString m_script;
	TQString m_osName;
	TQString m_osGUIName;
	
	bool fw_is_running;
	TQLabel *m_lrun;
	TQLabel *m_lshow;
	TQLabel *m_lconf;
	TQLabel *m_linstall;
	TQPushButton *m_brun_fw;
	TQPushButton *m_bstop_fw;
	TQPushButton *m_bshow_sript;
	TQPushButton *m_bshow_all;
	TQPushButton *m_bshow_filter;
	TQPushButton *m_bshow_nat;
	TQPushButton *m_bshow_mangle;
	TQPushButton *m_binstall;
	TQPushButton *m_buninstall;
	TQPushButton *m_bclose;
	TQGridLayout *m_layout;
	TQPixmap icon_run, icon_stop, icon_show;
	KMFError *m_err;
	KMFErrorHandler *m_err_handler;
	KTempFile *temp_file, *temp_file2;
	KMFProcOut *m_execWidget;
signals:
	void sigStatusChanged();
	void sigHideMe();
	void sigShowMe();
};




class KMFIPTInstallerFactory : public KLibFactory {
	Q_OBJECT
  TQ_OBJECT
public:
	KMFIPTInstallerFactory( TQObject *parent = 0, const char *name = 0 );
	virtual ~KMFIPTInstallerFactory() {};
	virtual TQObject* createObject( TQObject* parent = 0, const char* pname = 0,
	                               const char* name = TQOBJECT_OBJECT_NAME_STRING,
	                               const TQStringList &args = TQStringList() );
};
}

#endif // KMFIPTINSTALLER_H
