/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001
*/


#ifndef _KMFINSATLLERPART_H_
#define _KMFINSATLLERPART_H_


#include <tqstring.h>
#include <kparts/part.h>
#include <kparts/plugin.h>
#include <kparts/factory.h>
#include <kxmlgui.h>

// Project Includes
#include "../core/kmfplugin.h"
class TQWidget;
class TQPainter;
class KURL;
class KAction;
class KActionMenu;
class KInstance;

namespace KMF {

class KMFDoc;
class KMFProcOut;
class KMFCompilerInterface;
class KMyFirewall;
class KMFCompilerPlugin;
class KMFTarget;


/**
 * @author Christian Hubinger <chubinger@irrsinnig.org>
 */
class KMFInstallerPlugin : public KMFPlugin {
	Q_OBJECT
  TQ_OBJECT
public:
	/**
	 * Default constructor
	 */
	KMFInstallerPlugin( TQObject *parent, const char *name );

	/**
	 * Destructor
	 */
	virtual ~KMFInstallerPlugin();


			
public slots:
	void slotEnableActions( bool );

public slots:
	void slotStopFirewall();
	void slotStartFirewall();
	void slotShowScript();
	void slotShowConfig();
	void slotShowFilter();
	void slotShowNat();
	void slotShowMangle();
	void slotInstallFW();
	void slotUninstallFW();
	void slotGenerateInstallerPackage();
	
	
private:
// 	bool isLocalTarget();
	bool isConfigValid();
	
	void generateInstallerPackage( KMFTarget* );
	void cmdShowRunningConfig( const TQString& );

private:
	KMFDoc* m_doc;
	KAction* m_actionStopFw;
	KAction* m_actionRunFw;
	KAction* m_actionPreviewScript;
	KAction* m_actionShowConfig;
	KAction* m_actionShowFilter;
	KAction* m_actionShowNat;
	KAction* m_actionShowMangle;
	KActionMenu* m_actionMenu;
	KAction* m_actionInstallFW;
	KAction* m_actionUninstallFW;
	KAction* m_generateInstallPackage;
	enum { IPT, GENERIC };
	int m_docType;
	KMFProcOut *m_execWidget;
	KMFProcOut* execWidget();
};

class KMFInstallerPluginFactory : public KLibFactory {
	Q_OBJECT
  TQ_OBJECT
public:
	KMFInstallerPluginFactory( TQObject *parent = 0, const char *name = 0 );
	virtual ~KMFInstallerPluginFactory() {
		delete s_instance;
	};
	virtual TQObject* createObject( TQObject* parent = 0, const char* pname = 0,
	                               const char* name = TQOBJECT_OBJECT_NAME_STRING,
	                               const TQStringList &args = TQStringList() );
private:
	static KInstance* s_instance;
};
}
#endif // _KMFINSATLLERPART_H_
