//
// C++ Interface: kprocesswrapper
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFKPROCESSWRAPPER_H
#define KMFKPROCESSWRAPPER_H


// QT Includes
#include <tqobject.h>
#include <tqstring.h>

// KDE includes


class KProcess;

// Project includes
namespace KMF {
class KMFTarget;

/**
	@author Christian Hubinger <chubinger@irrsinnig.org>
*/
class KProcessWrapper : public TQObject {
Q_OBJECT
  TQ_OBJECT

//############# Beginn static stuff ##############	
public:
	/** return the one and only instance */
	static KProcessWrapper* instance();
private:	
	static KProcessWrapper* m_instance;
	
//############# End static stuff ##############

public:
    KProcessWrapper( TQObject*, const char* );

    ~KProcessWrapper();

	bool isRunning();
	
	const TQString& jobName() const {
		return m_jobName;
	}
	const TQString& stdOut() const {
		return m_stdOut;
	}
	const TQString& stdErr() const {
		return m_stdErr;
	}
	const TQString& stdCombined() const {
		return m_allOut;
	}
	const int exitStatus() const {
		return m_status;
	}
	const bool exitedNormal() const {
		return m_exitedNormal;
	}
	
public slots:
	void slotKillJob();

	void slotStartLocalJob( const TQString& jobName, const TQString& command, bool useKdeSu /* = false */, bool synchronous /* = false */); 
	void slotStartRemoteJob( const TQString& jobName, const TQString& scriptFile, KMFTarget* execHost ); 

protected slots:
	void slotReceivedOutput( KProcess*, char*, int );
	void slotReceivedError( KProcess*, char*, int );
	void slotProcessExited( KProcess* );
		

private:
	TQString* m_stderrbuf;
	TQString* m_stdoutbuf;
	
	TQString m_jobName;
	TQString m_allOut;
	int m_status;
	bool m_exitedNormal;
	
	TQString m_stdOut;
	TQString m_stdErr;
	KProcess* m_childproc;

signals:
	void sigProcessFinished( const TQString& jobName, int status, bool exitedNormal, const TQString& stdOut, const TQString& stdErr, const TQString& completeOut );
	
	void sigReceivedStdOut( const TQString& jobName, const TQString& stdOut );
	void sigReceivedStdErr( const TQString& jobName, const TQString& stdOut );
};

}

#endif
